<?php
include '../includes/conn.php';

// session guard
if (!isset($_SESSION['teachersys'])) {
  header('Location:login');
  exit;
}

// validate and cast id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$id = $id ? (int)$id : 0;
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="keywords" content="admin, dashboard, bootstrap, template, flat, modern, theme, responsive, fluid, retina, backend, html5, css, css3">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Subject Weekly Plan</title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/prettyphoto/css/prettyPhoto.css" type="text/css" media="screen" title="prettyPhoto main stylesheet" charset="utf-8" />
  <script src='<?php echo BASE_URL; ?>/js/fullcalendar/moment.min.js'></script>

</head>

<body class="sticky-header">

  <section>
    <?php include 'nav.php'; ?>


    <!--body wrapper start-->
    <div class="wrapper">
      <div class="row">

        <div class="col-lg-6">
          <!-- <a href="weeklyplanprint?id=<?php echo $id; ?>" class="btn btn-danger" target="_blank" style="margin-bottom: 10px">Print Lesson Plan</a> -->
          <?php
          // fetch weekly plan with joined class, subject and term data
          $weeklyplan_id = $startdate = $teacher_id = $enddate = $class_sub_id = $bookpages = $periodsperweek = $year = $term_value = $class_id = $subject_id = $category_id = 0;
          $class = $subject = $term = '';
          $weeklyplandoc = '';

          $wp_sql = "SELECT w.weeklyplan_id, w.startdate, w.teacher_id, w.enddate, w.class_sub_id, w.bookpages, w.periodsperweek, w.year AS w_year, w.term AS term_value, cs.class_id, cs.subject_id, c.class, c.category_id, s.subject, ft.term AS ft_term, ft.year AS ft_year, w.weeklyplandoc
            FROM weeklyplans w
            JOIN class_subjects cs ON w.class_sub_id = cs.class_sub_id
            JOIN classes c ON cs.class_id = c.class_id
            JOIN subjects s ON cs.subject_id = s.subject_id
            LEFT JOIN financialterms ft ON ft.financialterm_id = w.term AND ft.status = 1
            WHERE w.weeklyplan_id = ? AND w.status = 1 LIMIT 1";

          $wp_stmt = mysqli_prepare($con, $wp_sql);
          if ($wp_stmt) {
            mysqli_stmt_bind_param($wp_stmt, 'i', $id);
            mysqli_stmt_execute($wp_stmt);
            $wp_res = mysqli_stmt_get_result($wp_stmt);
            if ($wp_res && ($row = mysqli_fetch_assoc($wp_res))) {
              $weeklyplan_id = (int)($row['weeklyplan_id'] ?? 0);
              $startdate = (int)($row['startdate'] ?? 0);
              $teacher_id = (int)($row['teacher_id'] ?? 0);
              $enddate = (int)($row['enddate'] ?? 0);
              $class_sub_id = (int)($row['class_sub_id'] ?? 0);
              $bookpages = $row['bookpages'] ?? '';
              $periodsperweek = $row['periodsperweek'] ?? '';
              $year = $row['w_year'] ?? '';
              $term_value = $row['term_value'] ?? '';
              $class_id = (int)($row['class_id'] ?? 0);
              $subject_id = (int)($row['subject_id'] ?? 0);
              $class = $row['class'] ?? '';
              $category_id = (int)($row['category_id'] ?? 0);
              $subject = $row['subject'] ?? '';
              $term = $row['ft_term'] ?? ($row['term_value'] ?? '');
              $year = $row['ft_year'] ?? ($row['w_year'] ?? '');
              $weeklyplandoc = $row['weeklyplandoc'] ?? '';
            }
            mysqli_stmt_close($wp_stmt);
          }

          ?>
          <section class="panel">
            <header class="panel-heading">
              <?php echo $subject . ':' . $class . ' Week Plan'; ?>
            </header>
            <div class="panel-body">
              <table class="display table  table-striped" id="dynamic-table">

                <tbody>

                  <tr class="gradeA">
                    <th>Week Start</th>
                    <td><?php echo date('d/M/Y', $startdate); ?></td>
                  </tr>
                  <tr class="gradeA">
                    <th>Week End</th>
                    <td><?php echo date('d/M/Y', $enddate); ?></td>
                  </tr>
                  <?php
                  if ($category_id == 3) { ?>
                    <tr class="gradeA">
                      <th>Book Pages</th>
                      <td><?php echo $bookpages; ?></td>
                    </tr>
                  <?php } else { ?>
                    <tr class="gradeA">
                      <th>Periods per Week</th>
                      <td><?php echo $periodsperweek; ?></td>
                    </tr>
                    <tr class="gradeA">
                      <th>Year</th>
                      <td><?php echo $year; ?></td>
                    </tr>
                  <?php } ?>
                  <tr class="gradeA">
                    <th> Term</th>
                    <td><?php echo $term;            ?></td>
                  </tr>
                </tbody>
              </table>

            </div>
          </section>

        </div>
        <div class="col-lg-6">

        </div>

      </div>
      <div class="row">

        <div class="col-lg-10">
          <h2>Weekly Plan</h2>
          <?php
          // weeklyplandoc already fetched above
          if (!empty($weeklyplandoc)) {
            $pdf_path = $weeklyplandoc;
            if (file_exists($pdf_path)) {
          ?>
              <section class="panel">
                <header class="panel-heading">
                  Weekly Plan Document
                </header>
                <div class="panel-body">
                  <div class="pdf-container" style="width: 100%; height: 800px;">
                    <iframe
                      src="<?php echo $pdf_path; ?>"
                      width="100%"
                      height="100%"
                      style="border: none;"
                      type="application/pdf">
                    </iframe>
                  </div>
                </div>
              </section>
          <?php
            } else {
              echo '<div class="alert alert-warning">PDF file not found.</div>';
            }
          } else {
            echo '<div class="alert alert-info">No document uploaded for this weekly plan.</div>';
          }
          ?>
        </div>

      </div>

    </div>
    <!-- main content end-->
  </section>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
  <!--common scripts for all pages-->
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
  <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>

</body>

</html>