<?php
include '../includes/conn.php';
    if(!isset($_SESSION['teachersys'])){
header('Location:login.php');
     exit;
     }

// validate and cast id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$id = $id ? (int)$id : 0;
 ?>

<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title>Teacher Details | School Manager</title>

    <link href="../css/bootstrap.min.css" rel="stylesheet">
    <link href="../font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="../css/animate.css" rel="stylesheet">
    <link href="../css/style.css" rel="stylesheet">

</head>

<body>

    <div id="wrapper">

       <?php include 'nav.php'; ?>

        <div id="page-wrapper" class="gray-bg">
        <div class="row border-bottom">
        <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
        <div class="navbar-header">
            <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
            
        </div>
            <ul class="nav navbar-top-links navbar-right">
                                    
                <li>
                    <a href="logout">
                        <i class="fa fa-sign-out"></i> Log out
                    </a>
                </li>
            </ul>

        </nav>
        </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2>Teacher Profile</h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="">Home</a>
                        </li>
                        <li>
                            <a>Teacher</a>
                        </li>
                         
                        <li class="active">
                            <strong>View Teacher Profile</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>
        <div class="wrapper wrapper-content">
            <div class="row animated fadeInRight">
                <div class="col-md-4">
                    <div class="ibox float-e-margins">
                        <div class="ibox-title">
                                                            <?php
                        // fetch teacher details
                        $teacher_id = 0;
                        $fullname = $gender = $design = $status = $ext = $email = $phone = '';
                        $emp_stmt = mysqli_prepare($con, "SELECT teacher_id, fullname, gender, designation, status, ext, email, phone FROM teachers WHERE teacher_id = ? LIMIT 1");
                        if ($emp_stmt) {
                                mysqli_stmt_bind_param($emp_stmt, 'i', $id);
                                mysqli_stmt_execute($emp_stmt);
                                $emp_res = mysqli_stmt_get_result($emp_stmt);
                                if ($emp_res && ($row = mysqli_fetch_assoc($emp_res))) {
                                        $teacher_id = (int)($row['teacher_id'] ?? 0);
                                        $fullname = $row['fullname'] ?? '';
                                        $gender = $row['gender'] ?? '';
                                        $design = $row['designation'] ?? '';
                                        $status = $row['status'] ?? '';
                                        $ext = $row['ext'] ?? '';
                                        $email = $row['email'] ?? '';
                                        $phone = $row['phone'] ?? '';
                                }
                                mysqli_stmt_close($emp_stmt);
                        }
                        ?>
                                                        <h3><?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></h3>
                        </div>
                        <div>
                            <div class="ibox-content no-padding border-left-right" style="">
                                <img alt="image" class="img-responsive" src="../img/teachers/<?php echo htmlspecialchars(md5($teacher_id) . '.' . $ext, ENT_QUOTES); ?>" width="100%">
                            </div>
                            <div class="ibox-content profile-content">
                                <h4><strong>
                       <?php  echo htmlspecialchars($design, ENT_QUOTES);   ?></strong></h4>
                                                                                            
<!--                                <div class="user-button"> 
                                    <div class="row">                                       
                                        <div class="col-md-7">
                                           <a data-toggle="modal" class="btn btn-primary btn-sm" href="#modal-form"><i class="fa fa-edit"></i> Change Profile Picture</a>
                                        </div>
                                                                           
                                       
                                    </div>
                                </div>-->
                            </div>
                    </div>
                </div>
                    </div>
                
                <div class="col-md-8">
                    <div class="ibox float-e-margins">
                        <div class="ibox-title">
                            <h5>Teacher Information</h5>
                        
                        </div>
                        <div class="ibox-content">

                            <div>
                                <div class="feed-activity-list">
  <div class="feed-element">
                                                                              <div class="media-body ">
                                                <strong>Subjects Taught</strong> :  <?php
                                    // list classes and subjects taught by this teacher
                                    $ts_stmt = mysqli_prepare($con, "SELECT c.class, s.subject
                                        FROM teacher_subjects ts
                                        JOIN class_subjects cs ON ts.class_sub_id = cs.class_sub_id
                                        JOIN classes c ON cs.class_id = c.class_id
                                        JOIN subjects s ON cs.subject_id = s.subject_id
                                        WHERE ts.teacher_id = ?");
                                    if ($ts_stmt) {
                                        mysqli_stmt_bind_param($ts_stmt, 'i', $id);
                                        mysqli_stmt_execute($ts_stmt);
                                        $ts_res = mysqli_stmt_get_result($ts_stmt);
                                        while ($r = mysqli_fetch_assoc($ts_res)) {
                                            $class = $r['class'] ?? '';
                                            $subject = $r['subject'] ?? '';
                                            echo htmlspecialchars($class . ':' . $subject, ENT_QUOTES) . '&nbsp; ,&nbsp;';
                                        }
                                        mysqli_stmt_close($ts_stmt);
                                    }
                                    ?>
                                                                                                                              </div>
                                    </div>
                                    <div class="feed-element">
                                                                              <div class="media-body ">
                                                <strong>Designation</strong> : <?php echo $design;?>
                                                                                                                              </div>
                                    </div>
                                      
                                    <div class="feed-element">
                                                                              <div class="media-body ">
                                                <strong>Gender</strong> : <?php echo $gender;?>
                                                                                                                              </div>
                                    </div>
                                      <div class="feed-element">
                                                                              <div class="media-body ">
                                                <strong>Contact Number</strong> : <?php echo $phone;?>
                                                                                                                              </div>
                                    </div>
                                    <div class="feed-element">
                                                                              <div class="media-body ">
                                                <strong>Email</strong> : <?php echo $email;?>
                                                                                                                              </div>
                                    </div>
                                
                                     
                                  
                                             </div>
                            </div>

                        </div>
                    </div>
                  
                </div>
            </div>
        </div>
        </div>

    </div>

    <!-- Mainly scripts -->
    <script src="../js/jquery-1.10.2.min.js"></script>
    <script src="../js/bootstrap.js"></script>
    <script src="../js/plugins/metisMenu/jquery.metisMenu.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="../js/inspinia.js"></script>
    <script src="../js/plugins/pace/pace.min.js"></script>

    <!-- Peity -->
    <script src="../js/plugins/peity/jquery.peity.min.js"></script>

    <!-- Peity -->
    <script src="../js/demo/peity-demo.js"></script>

</body>


</html>
