<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys']) || ($_SESSION['classteacher'] ?? '') !== 'yes') {
  header('Location: login.php');
  exit;
}

$class_param = isset($_GET['class']) ? (string)$_GET['class'] : '';
if ($class_param === '') {
  echo '<div class="alert alert-danger">Missing class parameter</div>';
  exit;
}
$split = explode('_', $class_param);
$class_id = (int)(current($split) ?? 0);
$stream_id = (int)(end($split) ?? 0);

$class_name = '';
if ($class_id > 0) {
  $getclass = mysqli_query($con, "SELECT class FROM classes WHERE class_id='{$class_id}' LIMIT 1");
  if ($getclass && $row2 = mysqli_fetch_assoc($getclass)) {
    $class_name = $row2['class'] ?? '';
  }
}

$stream = '';
if ($stream_id > 0) {
  $getstream = mysqli_query($con, "SELECT stream FROM streams WHERE stream_id='{$stream_id}' LIMIT 1");
  if ($getstream && $row = mysqli_fetch_assoc($getstream)) {
    $stream = $row['stream'] ?? '';
  }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title><?php echo htmlspecialchars($class_name . ' ' . $stream); ?> TimeTable</title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'nav.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">

        <div class="col-lg-12">
          <section class="panel">
              <header class="panel-heading">
              <?php echo htmlspecialchars($class_name . ' ' . $stream); ?> TimeTable
              <a href="printtimetable?class=<?php echo htmlspecialchars($class_id . '_' . $stream_id); ?>" class="btn  btn-info pull-right" target="_blank">Print</a>
            </header>
            <div class="panel-body">
              <?php
              // Get all unique time slots for this class
              $time_slots_query = mysqli_query($con, "SELECT DISTINCT starttime, endtime FROM timetables 
                                                    WHERE class_id='{$class_id}' AND stream_id='{$stream_id}' 
                                                    ORDER BY starttime");

              // Get all days
              $days_query = mysqli_query($con, "SELECT short FROM days");
              $days = array();
              if ($days_query) {
                while ($day_row = mysqli_fetch_assoc($days_query)) {
                  $days[] = $day_row['short'] ?? '';
                }
              }
              ?>

              <div class="table-responsive">
                <table class="table table-bordered table-striped">
                  <thead>
                    <tr>
                      <th>Time</th>
                      <?php foreach ($days as $day): ?>
                        <th><?php echo htmlspecialchars(strtoupper($day)); ?></th>
                      <?php endforeach; ?>
                    </tr>
                  </thead>
                  <tbody>
                    <?php while ($time_slot = mysqli_fetch_assoc($time_slots_query)): ?>
                      <tr>
                        <td><?php echo htmlspecialchars(($time_slot['starttime'] ?? '') . ' - ' . ($time_slot['endtime'] ?? '')); ?></td>
                        <?php foreach ($days as $day): ?>
                          <td>
                            <?php
                            $day_esc = mysqli_real_escape_string($con, (string)$day);
                            $start_esc = mysqli_real_escape_string($con, (string)($time_slot['starttime'] ?? ''));
                            $end_esc = mysqli_real_escape_string($con, (string)($time_slot['endtime'] ?? ''));
                            $subject_query = mysqli_query($con, "SELECT t.activity, s.subject 
                                                              FROM timetables t 
                                                              LEFT JOIN class_subjects cs ON t.activity = cs.class_sub_id 
                                                              LEFT JOIN subjects s ON cs.subject_id = s.subject_id 
                                                              WHERE t.class_id='{$class_id}' 
                                                              AND t.stream_id='{$stream_id}' 
                                                              AND t.day='{$day_esc}' 
                                                              AND t.starttime='{$start_esc}' 
                                                              AND t.endtime='{$end_esc}' LIMIT 1");

                            if ($subject_query && mysqli_num_rows($subject_query) > 0) {
                              $subject_row = mysqli_fetch_assoc($subject_query);
                              if (!empty($subject_row['subject'])) {
                                echo htmlspecialchars($subject_row['subject']);
                              } else {
                                echo htmlspecialchars($subject_row['activity'] ?? '-');
                              }
                            } else {
                              echo '-';
                            }
                            ?>
                          </td>
                        <?php endforeach; ?>
                      </tr>
                    <?php endwhile; ?>
                  </tbody>
                </table>
              </div>

              <?php if ($_SESSION['classteacher'] == 'yes'): ?>
                <div class="text-center" style="margin-top: 20px;">
                  <a href="addtimetable?cl=<?php echo $class_id; ?>&&st=<?php echo $stream_id; ?>" class="btn btn-primary">
                    <i class="fa fa-plus"></i> Add/Edit Timetable
                  </a>
                </div>
              <?php endif; ?>

            </div>
          </section>
        </div>

      </div>


      </div>
      <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
  </section>

  <!-- Placed js at the end of the document so the pages load faster -->
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
  <!--common scripts for all pages-->
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>

</body>

</html>