<?php
// Single clean implementation for teacher/subjectdetails.php
include '../includes/conn.php';

// session guard
if (!isset($_SESSION['teachersys']) || ($_SESSION['classteacher'] ?? '') !== 'yes') {
    header('Location:login.php');
    exit;
}

// validate id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$id = $id === false || $id === null ? 0 : (int)$id;

// get subject and class
$subject = '';
$class = '';
$class_id = 0;
$stmt = mysqli_prepare($con, "SELECT s.subject, s.class_id, c.class FROM subjects s LEFT JOIN classes c ON c.class_id = s.class_id WHERE s.subject_id = ? LIMIT 1");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    if ($res && ($row = mysqli_fetch_assoc($res))) {
        $subject = $row['subject'] ?? '';
        $class_id = (int)($row['class_id'] ?? 0);
        $class = $row['class'] ?? '';
    }
    mysqli_stmt_close($stmt);
}

// fetch subject details
$subject_details = [];
$sd_stmt = mysqli_prepare($con, "SELECT subjectdetails_id, subject_id, term, description FROM subjectdetails WHERE subject_id = ? AND status = 1 ORDER BY subjectdetails_id DESC");
if ($sd_stmt) {
    mysqli_stmt_bind_param($sd_stmt, 'i', $id);
    mysqli_stmt_execute($sd_stmt);
    $sd_res = mysqli_stmt_get_result($sd_stmt);
    while ($r = mysqli_fetch_assoc($sd_res)) {
        $subject_details[] = $r;
    }
    mysqli_stmt_close($sd_stmt);
}
?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($subject . ' : ' . $class, ENT_QUOTES); ?> | School Manager</title>
    <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/animate.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
</head>
<body>
    <div id="wrapper">
        <?php include 'nav.php'; ?>
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
                    <div class="navbar-header">
                        <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i></a>
                    </div>
                    <ul class="nav navbar-top-links navbar-right">
                        <li>
                            <a href="logout">
                                <i class="fa fa-sign-out"></i> Log out
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><?php echo htmlspecialchars($subject . '  :  ' . $class, ENT_QUOTES); ?></h2>
                    <ol class="breadcrumb">
                        <li><a href=""><i class="fa fa-home"></i> Home</a></li>
                        <li class="active"><strong>View Subject</strong></li>
                    </ol>
                </div>
            </div>
            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox float-e-margins">
                            <div class="ibox-title"><h5>Term Outcomes <small>Sort, search</small></h5></div>
                            <div class="ibox-content">
                                <table class="table table-striped table-bordered table-hover dataTables-example">
                                    <thead>
                                        <tr>
                                            <th>Term</th>
                                            <th>Description</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach ($subject_details as $row):
                                        $subjectdetails_id = (int)($row['subjectdetails_id'] ?? 0);
                                        $term = htmlspecialchars($row['term'] ?? '', ENT_QUOTES);
                                        $description = strip_tags($row['description'] ?? '');
                                        $short = htmlspecialchars(mb_substr($description, 0, 100) . '...', ENT_QUOTES);
                                    ?>
                                        <tr class="gradeA">
                                            <td>Term <?php echo $term; ?></td>
                                            <td><?php echo $short; ?></td>
                                            <td><a href="termsubject?id=<?php echo htmlspecialchars($subjectdetails_id, ENT_QUOTES); ?>" class="btn btn-success btn-xs">Details</a></td>
                                        </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/jeditable/jquery.jeditable.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/dataTables.bootstrap.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.dataTables-example').dataTable();
        });
    </script>
</body>
</html>
                                            </div>
                                            </div>
                                        </div>
                                        </div>

                                    </div>

                                    <!-- Mainly scripts -->
                                    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
                                    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
                                    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>

                                    <script src="<?php echo BASE_URL; ?>/js/plugins/jeditable/jquery.jeditable.js"></script>

                                    <!-- Data Tables -->
                                    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/jquery.dataTables.js"></script>
                                    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/dataTables.bootstrap.js"></script>

                                    <!-- Custom and plugin javascript -->
                                    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
                                    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>

                                    <!-- Page-Level Scripts -->
                                    <script>
                                        $(document).ready(function() {
                                            $('.dataTables-example').dataTable();

                                            /* Init DataTables */
                                            var oTable = $('#editable').dataTable();

                                            /* Apply the jEditable handlers to the table */
                                            oTable.$('td').editable( 'http://webapplayers.com/example_ajax.php', {
                                                "callback": function( sValue, y ) {
                                                    var aPos = oTable.fnGetPosition( this );
                                                    oTable.fnUpdate( sValue, aPos[0], aPos[1] );
                                                },
                                                "submitdata": function ( value, settings ) {
                                                    return {
                                                        "row_id": this.parentNode.getAttribute('id'),
                                                        "column": oTable.fnGetPosition( this )[2]
                                                    };
                                                },

                                                "width": "90%"
                                            } );


                                        });

                                        function fnClickAddRow() {
                                            $('#editable').dataTable().fnAddData( [
                                                "Custom row",
                                                "New row",
                                                "New row",
                                                "New row",
                                                "New row" ] );

                                        }
                                    </script>
                                </body>


                                </html>