<?php
include '../includes/conn.php';

// session guard: redirect and exit if not logged in as a class teacher
if (!isset($_SESSION['teachersys']) || (($_SESSION['classteacher'] ?? '') !== 'yes')) {
    header('Location: login.php');
    exit;
}

$teacher_class_id = (int)($_SESSION['class_id'] ?? 0);

// prepare subjects query (type = 'specific')
$type = 'specific';
$subjects_stmt = mysqli_prepare($con, "SELECT subject_id, subject, creator, class_id FROM subjects WHERE status = 1 AND type = ? ORDER BY subject ASC");
if ($subjects_stmt === false) {
    die('DB prepare failed: ' . htmlspecialchars(mysqli_error($con), ENT_QUOTES));
}
mysqli_stmt_bind_param($subjects_stmt, 's', $type);
mysqli_stmt_execute($subjects_stmt);
$subjects = mysqli_stmt_get_result($subjects_stmt);

// reusable lookups
$class_stmt = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id = ? LIMIT 1");
$teacher_stmt = mysqli_prepare($con, "SELECT fullname FROM teachers WHERE teacher_id = ? LIMIT 1");

?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Specific Areas | School Manager</title>

    <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- Data Tables -->
    <link href="<?php echo BASE_URL; ?>/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">

    <link href="<?php echo BASE_URL; ?>/css/animate.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">

</head>

<body>

    <div id="wrapper">

        <?php include 'nav.php'; ?>

        <div id="page-wrapper" class="gray-bg">
        <div class="row border-bottom">
        <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
        <div class="navbar-header">
            <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
         
        </div>
            <ul class="nav navbar-top-links navbar-right">
                <li>
                    <a href="logout">
                        <i class="fa fa-sign-out"></i> Log out
                    </a>
                </li>
            </ul>

        </nav>
        </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2>Grade Specific Areas</h2>
                    <ol class="breadcrumb">
                         <li>              <a href=""><i class="fa fa-home"></i> Home</a>                    </li>
                       
                         <li>
                            <a>Subjects</a>
                        </li>
                        <li class="active">
                            <strong>View Specific Areas</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>
        <div class="wrapper wrapper-content animated fadeInRight">
            <div class="row">
               
                <div class="col-lg-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>All Specific Areas<small>Sort, search</small></h5>                       
                    </div>
                    <div class="ibox-content">

                        <?php if ($subjects && mysqli_num_rows($subjects) > 0): ?>
                        <table class="table table-striped table-bordered table-hover dataTables-example" >
                            <thead>
                            <tr>
                                <th>Subject</th>
                                <th>Class</th>
                                <th>Added By</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            while ($row = mysqli_fetch_assoc($subjects)) {
                                $subject_id = (int)($row['subject_id'] ?? 0);
                                $subject = $row['subject'] ?? '';
                                $creator = (int)($row['creator'] ?? 0);
                                $class_id = (int)($row['class_id'] ?? 0);

                                // lookup class name
                                $class_name = '';
                                if ($class_stmt) {
                                    mysqli_stmt_bind_param($class_stmt, 'i', $class_id);
                                    mysqli_stmt_execute($class_stmt);
                                    $cres = mysqli_stmt_get_result($class_stmt);
                                    $crow = mysqli_fetch_assoc($cres);
                                    $class_name = $crow['class'] ?? '';
                                }

                                // show only sessions for this teacher's class
                                if ($class_id !== $teacher_class_id) continue;

                                // lookup teacher fullname
                                $fullname = '';
                                if ($teacher_stmt) {
                                    mysqli_stmt_bind_param($teacher_stmt, 'i', $creator);
                                    mysqli_stmt_execute($teacher_stmt);
                                    $tres = mysqli_stmt_get_result($teacher_stmt);
                                    $trow = mysqli_fetch_assoc($tres);
                                    $fullname = $trow['fullname'] ?? '';
                                }
                                ?>
                                <tr class="gradeA">
                                    <td><?php echo htmlspecialchars($subject, ENT_QUOTES); ?></td>
                                    <td class="center"><?php echo htmlspecialchars($class_name, ENT_QUOTES); ?></td>
                                    <td><div class="tooltip-demo"><?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></div></td>
                                    <td class="center">
                                        <a href="subjectdetails?id=<?php echo $subject_id; ?>"  class="btn btn-info  btn-xs">Details <i class="fa fa-folder-open"></i></a>
                                        <a href="editsubject?id=<?php echo $subject_id; ?>"  class="btn btn-primary  btn-xs">Edit <i class="fa fa-edit"></i></a>
                                        <a href="hidesubject?id=<?php echo $subject_id; ?>"  class="btn btn-danger  btn-xs" onclick="return confirm('You are about To Remove this item. Are you sure you want to proceed?')">Remove <i class="fa fa-trash"></i></a>   
                                    </td>
                                </tr>
                            <?php } ?>
                            </tbody>
                        </table>
                        <?php else: ?>
                            <p>No specific areas found.</p>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
            </div>
          
        </div>
        </div>


    </div>


    <!-- Mainly scripts -->
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>

    <script src="<?php echo BASE_URL; ?>/js/plugins/jeditable/jquery.jeditable.js"></script>

    <!-- Data Tables -->
    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/dataTables.bootstrap.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>

    <!-- Page-Level Scripts -->
    <script>
        $(document).ready(function() {
            $('.dataTables-example').dataTable();
        });

        function fnClickAddRow() {
            $('#editable').dataTable().fnAddData( [
                "Custom row",
                "New row",
                "New row",
                "New row",
                "New row" ] );

        }
    </script>

    <?php
    // close prepared statements
    if (isset($subjects_stmt) && $subjects_stmt) mysqli_stmt_close($subjects_stmt);
    if (isset($class_stmt) && $class_stmt) mysqli_stmt_close($class_stmt);
    if (isset($teacher_stmt) && $teacher_stmt) mysqli_stmt_close($teacher_stmt);
    ?>
</body>
</html>