<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys']) || ($_SESSION['classteacher'] ?? '') !== 'yes') {
    header('Location: login.php');
    exit;
}
$teacher_id = (int)($_SESSION['teachersys'] ?? 0);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Reports</title>
     <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
             <div class="row">
    
    <div class="col-lg-10">
                      <section class="panel">
                    <header class="panel-heading">
                Reports
                    </header>
                          <div class="panel-body">
                                              <table  class="display table  table-striped"  id="dynamic-table">
        <thead>
        <tr>
                   <th>Term & Year</th>
                        <th>Added on</th>
                                            <th>Action</th>
                  </tr>
        </thead>
        <tbody>
                 <?php
                       // prepare statement to fetch reports for this teacher
                       $stmt = mysqli_prepare($con, "SELECT report_id, report, timestamp, term_id FROM reports WHERE status = 1 AND teacher_id = ?");
                       if ($stmt) {
                          mysqli_stmt_bind_param($stmt, 'i', $teacher_id);
                          mysqli_stmt_execute($stmt);
                          $res = mysqli_stmt_get_result($stmt);

                          // prepare term lookup statement once
                          $termStmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE financialterm_id = ? LIMIT 1");

                          while ($row2 = mysqli_fetch_assoc($res)) {
                              $report_id = (int)($row2['report_id'] ?? 0);
                              $report = $row2['report'] ?? '';
                              $timestamp = (int)($row2['timestamp'] ?? 0);
                              $term_id = (int)($row2['term_id'] ?? 0);

                              $term = '';
                              $year = '';
                              if ($termStmt) {
                                 mysqli_stmt_bind_param($termStmt, 'i', $term_id);
                                 mysqli_stmt_execute($termStmt);
                                 $tres = mysqli_stmt_get_result($termStmt);
                                 if ($row1 = mysqli_fetch_assoc($tres)) {
                                    $term = $row1['term'] ?? '';
                                    $year = $row1['year'] ?? '';
                                 }
                              }

                              $dateStr = $timestamp ? date('d/M/Y', $timestamp) : '';
                              ?>
                  <tr class="gradeA">
                 <td><?php echo htmlspecialchars('Term ' . $term . ' ' . $year, ENT_QUOTES); ?></td>
                 <td><?php echo htmlspecialchars($dateStr, ENT_QUOTES); ?></td>
                                       <td>
                                             <a href="report?id=<?php echo $report_id; ?>" class="btn btn-xs btn-primary"><i class="fa fa-folder"></i> Details</a>
                                             <a href="editreport?id=<?php echo $report_id; ?>" class="btn btn-xs btn-info"><i class="fa fa-edit"></i> Edit</a>
                                          <a href="removereport?id=<?php echo $report_id; ?>" class="btn btn-xs btn-danger" onclick="return confirm_delete<?php echo $report_id;?>()"><i class="fa fa-trash-o"></i> Remove</a>
                                       </td>
                                            <script type="text/javascript">
function confirm_delete<?php echo $report_id; ?>() {
   return confirm('You are about To Remove this item. Are you sure you want to proceed?');
}
</script>
                  </tr>
                       <?php }

                          if ($termStmt) {
                             mysqli_stmt_close($termStmt);
                          }
                          mysqli_stmt_close($stmt);
                       }
                       ?>
        </tbody>
                        </table>
                          </div>
                          </section>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
<script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>

</body>
</html>
