<?php
include '../includes/conn.php';
   if(!isset($_SESSION['teachersys'])){
    header('Location:login.php');
    exit;
   }

// validate id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$teacher_id = (int)($_SESSION['teachersys'] ?? 0);
if (!$id || !$teacher_id) {
    $redirect = $_SERVER['HTTP_REFERER'] ?? 'pastpapers.php';
    header('Location: ' . $redirect);
    exit;
}

// use prepared statement
$stmt = mysqli_prepare($con, "UPDATE pastpapers SET status = 0 WHERE pastpaper_id = ? AND teacher_id = ? LIMIT 1");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'ii', $id, $teacher_id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
}

$redirect = $_SERVER['HTTP_REFERER'] ?? 'pastpapers.php';
header('Location: ' . $redirect);
exit;
?>