<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
   header('Location:login.php');
   exit;
}

// validate and cast id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
   // fallback redirect if no referer
   $redirect = $_SERVER['HTTP_REFERER'] ?? 'timetable.php';
   header('Location: ' . $redirect);
   exit;
}

// use prepared statement for the update
$stmt = mysqli_prepare($con, "UPDATE timetables SET status = 0 WHERE timetable_id = ? LIMIT 1");
if ($stmt) {
   mysqli_stmt_bind_param($stmt, 'i', $id);
   mysqli_stmt_execute($stmt);
   mysqli_stmt_close($stmt);
}

$redirect = $_SERVER['HTTP_REFERER'] ?? 'timetable.php';
header('Location: ' . $redirect);
exit;
?>