<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
    header('Location:login.php');
    exit;
}

// Validate inputs
$std = filter_input(INPUT_GET, 'std', FILTER_VALIDATE_INT);
$tm  = filter_input(INPUT_GET, 'tm', FILTER_VALIDATE_INT);
if (!$std || !$tm) {
    echo '<div class="alert alert-danger">Invalid request parameters.</div>';
    exit;
}

// Helper: safe query wrapper for simple selects (dies on error with safe message)
function sq_select($con, $sql, $types = null, $params = []) {
    $stmt = mysqli_prepare($con, $sql);
    if (!$stmt) {
        $err = mysqli_error($con);
        die('<strong>DB prepare error:</strong> '.htmlspecialchars($err));
    }
    if ($types && $params) {
        mysqli_stmt_bind_param($stmt, $types, ...$params);
    }
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    mysqli_stmt_close($stmt);
    return $res;
}

// Get student basic info and class
$studentRes = sq_select($con, "SELECT student_id, fullname, class_id FROM students WHERE student_id = ? LIMIT 1", 'i', [$std]);
if (!$studentRes || mysqli_num_rows($studentRes) == 0) {
    echo '<div class="alert alert-danger">Student not found.</div>';
    exit;
}
$studentRow = mysqli_fetch_assoc($studentRes);
$student_id = (int)$studentRow['student_id'];
$fullname = $studentRow['fullname'] ?? '';
$class_id = (int)$studentRow['class_id'];

// Get class info
$classRes = sq_select($con, "SELECT class_id, class, report_type, average_type, category_id FROM classes WHERE class_id = ? LIMIT 1", 'i', [$class_id]);
$class = '';
$report_type = 0;
$aveage_type = 0;
$category_id = 0;
if ($classRes && mysqli_num_rows($classRes) > 0) {
    $c = mysqli_fetch_assoc($classRes);
    $class = $c['class'] ?? '';
    $report_type = isset($c['report_type']) ? (int)$c['report_type'] : 0;
    $aveage_type = isset($c['average_type']) ? (int)$c['average_type'] : 0;
    $category_id = isset($c['category_id']) ? (int)$c['category_id'] : 0;
}

// Get term info
$termRes = sq_select($con, "SELECT ft.*, fy.fyear FROM financialterms ft INNER JOIN financialyears fy ON ft.academic_year = fy.fyear_id WHERE ft.financialterm_id = ? LIMIT 1", 'i', [$tm]);
$term2 = '';
$year = '';
$academic_year = '';
$startdate_4 = 0;
$enddate_4 = 0;
$notice = '';
if ($termRes && mysqli_num_rows($termRes) > 0) {
    $tr = mysqli_fetch_assoc($termRes);
    $term2 = $tr['term'] ?? '';
    $year = $tr['year'] ?? '';
    $academic_year = $tr['fyear'] ?? '';
    $startdate_4 = $tr['startdate'] ?? 0;
    $enddate_4 = $tr['enddate'] ?? 0;
    $notice = $tr['important_notice'] ?? '';
}

// Principal/Head signatures
$fullname2 = '';
$psign_ext = $hsign_ext = '';
$staff_id3 = $staff_id2 = 0;
$dirRes = sq_select($con, "SELECT staff_id FROM users WHERE level = 2 AND status = 1 LIMIT 1");
if ($dirRes && mysqli_num_rows($dirRes) > 0) {
    $dr = mysqli_fetch_assoc($dirRes);
    $sid = isset($dr['staff_id']) ? (int)$dr['staff_id'] : 0;
    if ($sid) {
        $sres = sq_select($con, "SELECT fullname FROM staff WHERE staff_id = ? LIMIT 1", 'i', [$sid]);
        if ($sres && mysqli_num_rows($sres) > 0) {
            $sr = mysqli_fetch_assoc($sres);
            $fullname2 = $sr['fullname'] ?? '';
        }
    }
}

$hRes = sq_select($con, "SELECT staff_id, fullname, sign_ext FROM staff WHERE designation = 'Head Teacher' AND status = 1 LIMIT 1");
if ($hRes && mysqli_num_rows($hRes) > 0) {
    $hr = mysqli_fetch_assoc($hRes);
    $hsign_ext = $hr['sign_ext'] ?? '';
    $staff_id2 = isset($hr['staff_id']) ? (int)$hr['staff_id'] : 0;
    $headteachername = $hr['fullname'] ?? '';
} else { $headteachername = ''; }

$pRes = sq_select($con, "SELECT staff_id, fullname, sign_ext FROM staff WHERE designation = 'Principal' AND status = 1 LIMIT 1");
if ($pRes && mysqli_num_rows($pRes) > 0) {
    $pr = mysqli_fetch_assoc($pRes);
    $psign_ext = $pr['sign_ext'] ?? '';
    $staff_id3 = isset($pr['staff_id']) ? (int)$pr['staff_id'] : 0;
    $principalname = $pr['fullname'] ?? '';
} else { $principalname = ''; }

// Load grading map (try DB then defaults)
$grades = [];
$gq = sq_select($con, "SELECT grade_letter, grade_modifier, mark_range FROM grade_config WHERE classcategory_id = ? ORDER BY grade_letter DESC, grade_modifier DESC", 'i', [$category_id]);
if ($gq && mysqli_num_rows($gq) > 0) {
    while ($gg = mysqli_fetch_assoc($gq)) {
        $label = $gg['grade_letter'] . ($gg['grade_modifier'] ?? '');
        $range = trim($gg['mark_range']);
        $r = str_replace('%', '', $range);
        $r = preg_replace('/\\s*-\\s*/', '-', $r);
        $r = $r . '%';
        $grades[] = ['label' => $label, 'range' => $r];
    }
} else {
    $grades = [
        ['label' => 'A*', 'range' => '86-100%'],
        ['label' => 'A',  'range' => '81-85%'],
        ['label' => 'B+', 'range' => '76-80%'],
        ['label' => 'B',  'range' => '71-75%'],
        ['label' => 'B-', 'range' => '66-70%'],
        ['label' => 'C+', 'range' => '61-65%'],
        ['label' => 'C',  'range' => '56-60%'],
        ['label' => 'C-', 'range' => '51-55%'],
        ['label' => 'D',  'range' => '41-50%'],
        ['label' => 'E',  'range' => '31-40%'],
        ['label' => 'U',  'range' => '0-30%']
    ];
}

function find_grade_from_percent($percent, $grades_map) {
    if ($percent === null || $percent === '' || strtoupper($percent) === 'N/A') return 'N/A';
    $p = intval($percent);
    $isIndexed = array_keys($grades_map) === range(0, count($grades_map) - 1);
    if ($isIndexed) {
        foreach ($grades_map as $entry) {
            $label = $entry['label'] ?? '';
            $range = $entry['range'] ?? '';
            $range = str_replace('%', '', $range);
            if (strpos($range, '-') !== false) {
                list($min, $max) = explode('-', $range, 2);
                $min = intval(trim($min)); $max = intval(trim($max));
                if ($min > $max) { $t=$min; $min=$max; $max=$t; }
                if ($p >= $min && $p <= $max) return $label;
            }
        }
        return 'U';
    }
    foreach ($grades_map as $g => $range) {
        $r = str_replace('%', '', $range);
        if (strpos($r, '-') !== false) {
            list($min, $max) = explode('-', $r, 2);
            $min = intval(trim($min)); $max = intval(trim($max));
            if ($min > $max) { $t=$min; $min=$max; $max=$t; }
            if ($p >= $min && $p <= $max) return $g;
        }
    }
    return 'U';
}

function normalize_mark($rawMark, $rank, $scaleTo) {
    if ($rawMark === null || $rawMark === '' || strtoupper($rawMark) === 'N/A') return null;
    if (intval($rank) == 0) return null;
    $raw = floatval($rawMark);
    $rk = floatval($rank);
    $percentOfFull = ($raw / $rk);
    $scaled = round($percentOfFull * $scaleTo);
    return intval($scaled);
}

// Load papers and class subjects
$papers = [];
$pr = sq_select($con, "SELECT * FROM papers WHERE status='1' ORDER BY paper_id");
if ($pr) while ($pp = mysqli_fetch_assoc($pr)) $papers[] = $pp;

$classmarks = sq_select($con, "SELECT * FROM class_subjects WHERE class_id = ? ORDER BY subject_id", 'i', [$class_id]);

// Attendance summary
$absent = $present = $present2 = 0;
$attRes = sq_select($con, "SELECT * FROM attendance WHERE term_id = ? AND class_id = ?", 'ii', [$tm, $class_id]);
if ($attRes) {
    while ($rowt = mysqli_fetch_assoc($attRes)) {
        $attendance_id = $rowt['attendance_id'];
        $a0 = sq_select($con, "SELECT COUNT(*) AS cnt FROM attendancedetails WHERE status=0 AND student_id=? AND attendance_id=?", 'ii', [$std, $attendance_id]);
        $a1 = sq_select($con, "SELECT COUNT(*) AS cnt FROM attendancedetails WHERE status=1 AND student_id=? AND attendance_id=?", 'ii', [$std, $attendance_id]);
        $a2 = sq_select($con, "SELECT COUNT(*) AS cnt FROM attendancedetails WHERE status=2 AND student_id=? AND attendance_id=?", 'ii', [$std, $attendance_id]);
        $absent += ($a0 && mysqli_num_rows($a0) ? (int)mysqli_fetch_assoc($a0)['cnt'] : 0);
        $present += ($a1 && mysqli_num_rows($a1) ? (int)mysqli_fetch_assoc($a1)['cnt'] : 0);
        $present2 += ($a2 && mysqli_num_rows($a2) ? (int)mysqli_fetch_assoc($a2)['cnt'] : 0);
    }
}
$overall_days = $absent + $present + $present2;

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Progress Report - <?php echo htmlspecialchars($fullname); ?></title>

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <style>
        @page { size: A4; margin: 20mm; }
        html,body{ font-family: Arial, "Helvetica Neue", Helvetica, sans-serif; color:#000; height:100%; -webkit-print-color-adjust:exact; }
        body { margin:0; padding:0; background:#fff; }
        .container { width:100%; box-sizing:border-box; padding:0 20mm; }
        @media screen { .container { padding:0 20px; max-width:100%; } .effort-box { width: calc(100% - 40px) !important; max-width: calc(100% - 40px) !important; } }
        @media print { .container { padding:0 20mm; max-width: calc(100% - 40mm); } .effort-box { width: calc(100% - 40mm) !important; max-width: calc(100% - 40mm) !important; } }
        .report-header { display:flex; justify-content:space-between; align-items:flex-start; gap:12px; margin-bottom:8px; }
        .header-left { flex:1 1 65%; }
        .school-title { font-family:"Georgia", "Times New Roman", serif; color:#1f67a8; font-size:28px; margin:0 0 2px 0; font-weight:700; }
        .school-subtitle { color:#6aa14e; font-size:14px; margin:0 0 6px 0; font-weight:600; }
        .contact-info p { margin:0; font-size:12px; }
        .header-right { width:180px; text-align:center; }
        .school-logo { width:80px; height:80px; object-fit:contain; border-radius:50%; display:block; margin:0 auto 6px auto; }
        .academic-year { font-weight:700; font-size:12px; }
        .term-bar { background:#d6dce0; border:1px solid #000; padding:8px 12px; text-align:center; font-weight:700; margin-top:10px; margin-bottom:10px; }
        .student-row { display:flex; justify-content:space-between; align-items:center; margin-bottom:8px; font-size:14px; }
        .underline-field { border-bottom:2px solid #000; padding-bottom:4px; display:inline-block; min-width:240px; margin-left:6px; font-weight:700; }
        .year-field { border-bottom:2px solid #000; padding-bottom:4px; min-width:80px; display:inline-block; font-weight:700; text-align:center; }
        .subject-table { width:100%; border-collapse:collapse; margin-top:8px; page-break-inside:auto; }
        .subject-table thead { display:table-header-group; }
        .subject-table th, .subject-table td { border:1px solid #000; padding:6px 8px; vertical-align:middle; font-size:12px; }
        .subject-table thead th { background:#2f87c8; color:#fff; font-weight:700; text-transform:none; text-align:center; }
        .subject-name { text-align:left; font-weight:600; }
        .num { text-align:center; }
        .grading-table { width:100%; border-collapse:collapse; margin-top:12px; }
        .grading-table th, .grading-table td { border:1px solid #000; padding:6px; font-size:12px; text-align:center; }
        .grading-title { background:#c6efce; font-weight:700; }
        .effort-box { margin-top:12px; border:1px solid #000; padding:6px; width:100% !important; max-width:100% !important; display:block !important; clear:both !important; float:none !important; box-sizing:border-box; }
        .effort-row { border-top:1px solid #000; padding:6px; display:flex; gap:10px; flex-wrap:nowrap; align-items:center; }
        .effort-row:first-child { border-top:none; }
        .comments { border:2px solid #000; padding:10px; min-height:80px; box-sizing:border-box; }
        .comments h3 { margin:0 0 6px 0; padding:6px; background:#c6efce; border-bottom:2px solid #000; text-align:center; }
        .attendance { margin-top:12px; width:320px; border-collapse:collapse; }
        .attendance td { border:1px solid #000; padding:6px; font-size:13px; }
        .signatures { margin-top:18px; display:flex; justify-content:space-between; gap:20px; }
        .sign-box { width:45%; text-align:left; }
        .sign-box img { width:120px; height:auto; display:block; margin-top:6px; }
        .notice { margin-top:18px; border:2px solid #000; padding:8px; box-sizing:border-box; }
        .notice h4 { margin:0 0 6px 0; background:#c6efce; padding:6px; font-size:14px; text-align:center; border-bottom:2px solid #000; }
        footer { margin-top:18px; text-align:center; font-size:11px; color:#444; }
        .comments, .notice, .subject-table, .grading-table, .effort-box { page-break-inside:avoid; }
    </style>
</head>
<body>
<div class="container">
    <header class="report-header" role="banner">
        <div class="header-left">
            <h1 class="school-title">The King's School</h1>
            <div class="school-subtitle">Christian, English Speaking, International School</div>
            <div class="contact-info" aria-label="school contact information">
                <p>P.O. BOX 1560, Bujumbura, Burundi</p>
                <p>TEL: (+257) 22 27 96 78 / 69 84 04 78</p>
                <p>Email: secondary.school@thekingsschool.edu.bl</p>
                <p>Website: www.thekingsschool.edu.bl</p>
            </div>
        </div>

        <div class="header-right" role="img" aria-label="school logo and academic year">
            <img class="school-logo" src="<?php echo BASE_URL; ?>/images/schoollogo.JPG" alt="The King's School logo">
            <div class="academic-year">ACADEMIC YEAR: <?php echo htmlspecialchars($academic_year); ?></div>
        </div>
    </header>

    <div class="term-bar">TERM <?php echo htmlspecialchars($term2); ?> REPORT - <?php echo date('M/Y', $enddate_4); ?></div>

    <div class="student-row" role="region" aria-label="student information">
        <div><strong>Student Name:</strong> <span class="underline-field"><?php echo htmlspecialchars($fullname); ?></span></div>
        <div><strong>Year:</strong> <span class="year-field"><?php $class3 = $class; $parts = preg_split('/\\s+/', trim($class3)); $yearDisplay = end($parts); echo htmlspecialchars($yearDisplay); ?></span></div>
    </div>

    <?php if ($classmarks && mysqli_num_rows($classmarks) > 0): ?>
        <table class="subject-table" role="table" aria-label="subject scores">
            <thead>
                <tr>
                    <th style="text-align:left">Subject</th>
                    <th>Classwork /40</th>
                    <th>Exam /60</th>
                    <th>Cumulative %</th>
                    <th>Grade</th>
                    <th>Effort</th>
                    <th>Class average</th>
                </tr>
            </thead>
            <tbody>
            <?php
            if ($classmarks) mysqli_data_seek($classmarks, 0);
            while ($row = mysqli_fetch_assoc($classmarks)) {
                $subject_id = (int)$row['subject_id'];
                $sres = sq_select($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1", 'i', [$subject_id]);
                $subject = '';
                if ($sres && mysqli_num_rows($sres)>0) { $sr = mysqli_fetch_assoc($sres); $subject = $sr['subject'] ?? ''; }

                // classwork
                $cwmark = null; $cw_rank = 0;
                $cw = sq_select($con, "SELECT marks, rank FROM marks WHERE class_id=? AND student_id=? AND term_id=? AND subject_id=? AND assessment='1' AND status='1' LIMIT 1", 'iiii', [$class_id, $std, $tm, $subject_id]);
                if ($cw && mysqli_num_rows($cw)>0) { $cwrow = mysqli_fetch_assoc($cw); $cwmark = normalize_mark($cwrow['marks'] ?? null, $cwrow['rank'] ?? 0, 40); }

                // exam
                $exammark = null; $effort_id = 0;
                $ex = sq_select($con, "SELECT marks, rank, effort_id FROM marks WHERE class_id=? AND student_id=? AND term_id=? AND subject_id=? AND assessment='2' AND status='1' LIMIT 1", 'iiii', [$class_id, $std, $tm, $subject_id]);
                if ($ex && mysqli_num_rows($ex)>0) { $erow = mysqli_fetch_assoc($ex); $exammark = normalize_mark($erow['marks'] ?? null, $erow['rank'] ?? 0, 60); $effort_id = isset($erow['effort_id']) ? (int)$erow['effort_id'] : 0; }

                if ($cwmark === null && $exammark === null) continue;

                $finalmark = 0; if ($cwmark !== null) $finalmark += intval($cwmark); if ($exammark !== null) $finalmark += intval($exammark);
                $grade_label = ($finalmark === null || ($finalmark===0 && $exammark===null)) ? 'N/A' : find_grade_from_percent($finalmark, $grades);

                $effort_display = '';
                if ($effort_id) {
                    $effr = sq_select($con, "SELECT rank FROM effort_types WHERE effort_id = ? LIMIT 1", 'i', [$effort_id]);
                    if ($effr && mysqli_num_rows($effr)>0) { $e = mysqli_fetch_assoc($effr); $effort_display = $e['rank']; }
                }

                // class average simple method
                $classavg_display = '';
                if ($aveage_type != 0) {
                    $gq = mysqli_query($con, "SELECT marks, rank FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND assessment='2' AND status='1'");
                    $count = 0; $totalPercent = 0;
                    while ($ravg = mysqli_fetch_assoc($gq)) {
                        $m = $ravg['marks']; $rk = $ravg['rank'] ? $ravg['rank'] : 0;
                        if ($m === null || strtoupper($m) === 'N/A' || $rk == 0) continue;
                        $percent = round((intval($m) / intval($rk)) * 100);
                        $totalPercent += $percent; $count++;
                    }
                    if ($count>0) $classavg_display = round($totalPercent / $count);
                } else {
                    // fallback approximate average across paper 1
                    $studentsResult = mysqli_query($con, "SELECT student_id FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND assessment='2' AND status='1' AND marks != 'N/A' AND marks !='' and paper_id='1'");
                    $totalStudents = mysqli_num_rows($studentsResult);
                    $totalMarks = [];
                    if ($totalStudents>0) {
                        while ($studentRow = mysqli_fetch_assoc($studentsResult)) {
                            $studentId = $studentRow['student_id'];
                            $paperQuery = mysqli_query($con, "SELECT * FROM papers WHERE status='1'");
                            $studentTotalPercent = 0; $paperCount = 0;
                            while ($paperRow = mysqli_fetch_assoc($paperQuery)) {
                                $paperId = $paperRow['paper_id'];
                                $getMarksQuery = mysqli_query($con, "SELECT marks, rank FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND paper_id='$paperId' AND assessment='2' AND status='1' AND marks != 'N/A' AND marks !='' AND student_id='$studentId'");
                                $marksCount = mysqli_num_rows($getMarksQuery);
                                if ($marksCount>0) {
                                    $sumThisPaper = 0; $countThisPaper = 0;
                                    while ($mRow = mysqli_fetch_assoc($getMarksQuery)) {
                                        $markVal = intval($mRow['marks']); $rank_s = intval($mRow['rank']) ?: 0;
                                        if ($rank_s > 0) { $sumThisPaper += round($markVal / $rank_s * 100); $countThisPaper++; }
                                    }
                                    if ($countThisPaper>0) { $studentTotalPercent += round($sumThisPaper / $countThisPaper); $paperCount++; }
                                }
                            }
                            if ($paperCount>0) $totalMarks[] = round($studentTotalPercent / $paperCount);
                        }
                        if (count($totalMarks)>0) $classavg_display = round(array_sum($totalMarks) / count($totalMarks));
                    }
                }
                ?>
                <tr>
                    <td class="subject-name"><?php echo htmlspecialchars($subject); ?></td>
                    <td class="num"><?php echo ($cwmark !== null) ? htmlspecialchars($cwmark) : ''; ?></td>
                    <td class="num"><?php echo ($exammark !== null) ? htmlspecialchars($exammark) : ''; ?></td>
                    <td class="num"><?php echo ($finalmark !== null) ? htmlspecialchars($finalmark) : 'N/A'; ?></td>
                    <td class="num"><?php echo htmlspecialchars($grade_label); ?></td>
                    <td class="num"><?php echo ($effort_display !== '') ? htmlspecialchars($effort_display) : ''; ?></td>
                    <td class="num"><?php echo ($classavg_display !== '') ? htmlspecialchars($classavg_display) : ''; ?></td>
                </tr>
            <?php } // end while subjects ?>
            </tbody>
        </table>
    <?php else: ?>
        <div style="border:1px solid #000; padding:12px; margin-top:10px;">Oops!! No Marks Added Yet</div>
    <?php endif; ?>

    <table class="grading-table" aria-label="grading legend">
        <thead>
            <tr><th class="grading-title" colspan="<?php echo max(1, count($grades)); ?>">Grading</th></tr>
            <tr>
                <?php foreach ($grades as $g): ?>
                    <th><?php echo htmlspecialchars($g['label']); ?></th>
                <?php endforeach; ?>
            </tr>
        </thead>
        <tbody>
            <tr>
                <?php foreach ($grades as $g): ?>
                    <td><?php echo htmlspecialchars($g['range']); ?></td>
                <?php endforeach; ?>
            </tr>
        </tbody>
    </table>

    <div style="text-align:center; margin-top:8px; font-weight:700;">#N/A - Subject not taken or Subject not done. <br> Classwork - Tests/Homeworks/Assignments etc.</div>

    <div class="effort-box" role="note" aria-label="effort descriptions">
        <div style="font-weight:700; margin-bottom:6px; text-align:center;">Effort</div>
        <div>
            <?php
            $geteffort = sq_select($con, "SELECT * FROM effort_types WHERE status='1' ORDER BY rank ASC");
            if ($geteffort) {
                while ($rowss = mysqli_fetch_assoc($geteffort)) {
                    $effort_d = $rowss['description'];
                    $rank = $rowss['rank'];
                    echo '<div class="effort-row"><div style="width:40px;text-align:right;font-weight:700;">' . str_pad($rank, 2, ' ', STR_PAD_LEFT) . '</div><div style="flex:1;padding-left:8px;">' . htmlspecialchars($effort_d) . '</div></div>';
                }
            }
            ?>
        </div>
    </div>

    <div class="comments" id="teacher_comment" aria-labelledby="comments-heading">
        <h3 id="comments-heading">Class Tutor's Comments</h3>
        <div>
            <?php
            $getreports = sq_select($con, "SELECT * FROM subjecttermreports WHERE class_id=? AND term_id=? AND student_id=? AND status=1 LIMIT 1", 'iii', [$class_id, $tm, $std]);
            if (!$getreports || mysqli_num_rows($getreports) == 0) {
                echo '<p>No Comments</p>';
            } else {
                $r = mysqli_fetch_assoc($getreports);
                $cleanReport = strip_tags($r['report']);
                echo '<p>' . nl2br(htmlspecialchars($cleanReport)) . '</p>';
            }
            ?>
        </div>
    </div>

    <div style="display:flex; justify-content:center; gap:20px; margin-top:12px; align-items:center;">
        <table class="attendance" aria-label="attendance">
            <tbody>
                <tr><td>Total days in the Term</td><td style="text-align:center;"><?php echo intval($overall_days); ?></td></tr>
                <tr><td>Number of days Late</td><td style="text-align:center;"><?php echo intval($present2); ?></td></tr>
                <tr><td>Number of days Absent</td><td style="text-align:center;"><?php echo intval($absent); ?></td></tr>
            </tbody>
        </table>
    </div>

    <div class="signatures" aria-label="signatures">
        <div class="sign-box">
            <div><strong>Principal :</strong> <?php echo htmlspecialchars($principalname); ?></div>
            <?php if (!empty($psign_ext) && !empty($staff_id3)): ?>
                <img alt="Principal signature" src="<?php echo BASE_URL; ?>/images/nonteaching/<?php echo md5($staff_id3) . '.' . $psign_ext ?>">
            <?php endif; ?>
        </div>
        <div class="sign-box" style="text-align:right;">
            <div><strong>Head Teacher :</strong> <?php echo htmlspecialchars($headteachername); ?></div>
            <?php if (!empty($hsign_ext) && !empty($staff_id2)): ?>
                <img alt="Head teacher signature" src="<?php echo BASE_URL; ?>/images/nonteaching/<?php echo md5($staff_id2) . '.' . $hsign_ext ?>">
            <?php endif; ?>
        </div>
    </div>

    <div class="notice" aria-label="important notice">
        <h4>Important Notice!</h4>
        <p><?php echo !empty($notice) ? nl2br(htmlspecialchars($notice)) : 'No Important Notice'; ?></p>
    </div>

    <footer>&copy; <?php echo date('Y'); ?> The King's School — '...training today's students, equipping tomorrow's leaders'</footer>
</div>

<script> // window.print(); </script>
</body>
</html>
   
