<?php
include '../includes/conn.php';
if(!isset($_SESSION['teachersys'])){
  header('Location:login.php');
  exit;
}

// validate inputs
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$term = filter_input(INPUT_GET, 'term', FILTER_VALIDATE_INT);
if (!$id || !$term) {
  echo '<div class="alert alert-danger">Invalid request parameters.</div>';
  exit;
}
?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>View Student Marks-School Manager</title>
 <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
 <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
        <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->
     
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="sticky-header">
<section>
<?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-8">
                      <section class="panel">
                        <?php
                                // fetch term info
                                $term2 = '';
                                $year = '';
                                $tstmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE financialterm_id = ? LIMIT 1");
                                if ($tstmt) {
                                  mysqli_stmt_bind_param($tstmt, 'i', $term);
                                  mysqli_stmt_execute($tstmt);
                                  $tres = mysqli_stmt_get_result($tstmt);
                                  if ($tres && mysqli_num_rows($tres) > 0) {
                                    $trow = mysqli_fetch_assoc($tres);
                                    $term2 = $trow['term'] ?? '';
                                    $year = $trow['year'] ?? '';
                                  }
                                  mysqli_stmt_close($tstmt);
                                }
                                ?>
                    <header class="panel-heading">
                   <?php echo $year.' '.$term2; ?> Marks
                    </header>
                             <div class="panel-body">  
          <?php
              // determine class_id from a mark row (fallback to students table)
              $class_id = 0;
              $mstmt_one = mysqli_prepare($con, "SELECT class_id FROM marks WHERE term_id = ? AND student_id = ? LIMIT 1");
              if ($mstmt_one) {
                mysqli_stmt_bind_param($mstmt_one, 'ii', $term, $id);
                mysqli_stmt_execute($mstmt_one);
                $mres_one = mysqli_stmt_get_result($mstmt_one);
                if ($mres_one && mysqli_num_rows($mres_one) > 0) {
                  $mrow_one = mysqli_fetch_assoc($mres_one);
                  $class_id = isset($mrow_one['class_id']) ? (int)$mrow_one['class_id'] : 0;
                }
                mysqli_stmt_close($mstmt_one);
              }

              // fallback: get from students table
              $fullname = '';
              $student_id = $id;
              $sst = mysqli_prepare($con, "SELECT fullname, class_id FROM students WHERE student_id = ? LIMIT 1");
              if ($sst) {
                mysqli_stmt_bind_param($sst, 'i', $id);
                mysqli_stmt_execute($sst);
                $sres = mysqli_stmt_get_result($sst);
                if ($sres && mysqli_num_rows($sres) > 0) {
                  $srow = mysqli_fetch_assoc($sres);
                  $fullname = $srow['fullname'] ?? '';
                  if (empty($class_id)) $class_id = isset($srow['class_id']) ? (int)$srow['class_id'] : 0;
                }
                mysqli_stmt_close($sst);
              }

              // fetch class info
              $class2 = '';
              $category_id = 0;
              if ($class_id) {
                $cstmt = mysqli_prepare($con, "SELECT class, category_id FROM classes WHERE class_id = ? LIMIT 1");
                if ($cstmt) {
                  mysqli_stmt_bind_param($cstmt, 'i', $class_id);
                  mysqli_stmt_execute($cstmt);
                  $cres = mysqli_stmt_get_result($cstmt);
                  if ($cres && mysqli_num_rows($cres) > 0) {
                    $crow = mysqli_fetch_assoc($cres);
                    $class2 = $crow['class'] ?? '';
                    $category_id = isset($crow['category_id']) ? (int)$crow['category_id'] : 0;
                  }
                  mysqli_stmt_close($cstmt);
                }
              }
            ?>
                                <table  class="display table  table-striped" id="dynamic-table">
             <tbody>
         
                <tr class="gradeA">
                       <th>Student</th>
                       <td><?php echo $fullname;?></td>
                  </tr>
                 <tr class="gradeA">
                       <th>Class</th>
                       <td><?php echo $class2;?></td>
                  </tr>
                    
                           <tr class="gradeA">
                             <th> Term</th>
                             <td><?php echo 'Term '.$term2.' '.$year;?></td>
            </tr>
             
                   </tbody>
                        </table>
                                      
                           
              </div>
                          </section>
                    </div>
                <div class="col-lg-10">
                    <a href="progressreport?std=<?php echo $id;?>&&tm=<?php echo $term;?>" class="btn btn-info" style="margin-bottom: 10px">Print Report</a>
                      <section class="panel">
                    <header class="panel-heading">
                  Student Results
                    </header>
                                        <div class="panel-body"> 
                                  
                            <?php
                            // get distinct subject_ids for the class and term
                            $subStmt = mysqli_prepare($con, "SELECT subject_id FROM marks WHERE class_id = ? AND term_id = ? GROUP BY subject_id");
                            if ($subStmt) {
                              mysqli_stmt_bind_param($subStmt, 'ii', $class_id, $term);
                              mysqli_stmt_execute($subStmt);
                              $sres = mysqli_stmt_get_result($subStmt);
                            } else {
                              $sres = null;
                            }
                            if (!empty($sres) && mysqli_num_rows($sres) > 0) {
                     ?>
                    <table class="table table-striped table-bordered table-hover dataTables-example" >
                    <thead>
                    <tr>
                        <th>Subjects</th>
                                    <th  colspan="2" class="text-center">Assignments</th>
                                    <th  colspan="2" class="text-center"> Exam</th>
                                    <th>Final Mark</th>
                    </tr>
                    </thead>
                    <tbody>
      <?php
      while ($srow = mysqli_fetch_assoc($sres)) {
        $subject_id = isset($srow['subject_id']) ? (int)$srow['subject_id'] : 0;
        // fetch subject name
        $subName = '';
        $ssub = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1");
        if ($ssub) {
          mysqli_stmt_bind_param($ssub, 'i', $subject_id);
          mysqli_stmt_execute($ssub);
          $ssres = mysqli_stmt_get_result($ssub);
          if ($ssres && mysqli_num_rows($ssres) > 0) {
            $sdat = mysqli_fetch_assoc($ssres);
            $subName = $sdat['subject'] ?? '';
          }
          mysqli_stmt_close($ssub);
        }
      ?>      <tr class="gradeA">
              <td><?php echo htmlspecialchars($subName, ENT_QUOTES); ?></td>
              <td>
                <?php
                // aggregate assignments
                $assignStmt = mysqli_prepare($con, "SELECT SUM(marks) AS totalmarks, SUM(rank) AS totalranks FROM marks WHERE class_id = ? AND student_id = ? AND term_id = ? AND subject_id = ? AND assessment = 'Assignment' GROUP BY subject_id");
                $averagemarks = 0;
                if ($assignStmt) {
                  mysqli_stmt_bind_param($assignStmt, 'iiii', $class_id, $student_id, $term, $subject_id);
                  mysqli_stmt_execute($assignStmt);
                  $ares = mysqli_stmt_get_result($assignStmt);
                  if ($ares && mysqli_num_rows($ares) > 0) {
                    $adat = mysqli_fetch_assoc($ares);
                    $totalmarks = isset($adat['totalmarks']) ? (int)$adat['totalmarks'] : 0;
                    $totalranks = isset($adat['totalranks']) ? (int)$adat['totalranks'] : 0;
                    if ($totalranks > 0) {
                      $averagemarks = round((intval($totalmarks) / intval($totalranks)) * 100);
                    }
                  }
                  mysqli_stmt_close($assignStmt);
                }
                echo htmlspecialchars($averagemarks . '%', ENT_QUOTES);
            ?>
              </td>
              <td>
                <?php
              if(($averagemarks>=90)&&($averagemarks<=100)){       echo 'A*';     }
              if(($averagemarks>=80)&&($averagemarks<=89)){       echo 'A';     }
              if(($averagemarks>=70)&&($averagemarks<=79)){       echo 'B+';     }
              if(($averagemarks>=60)&&($averagemarks<=69)){       echo 'B';     }
              if(($averagemarks>=50)&&($averagemarks<=59)){       echo 'C';     }
              if(($averagemarks>=45)&&($averagemarks<=49)){       echo 'D';     }
              if($averagemarks<45){       echo 'F';     }
                          
              ?></td>
              <td>
           <?php
             // exam mark (assessment '3')
             $exammark = 0;
             $examStmt = mysqli_prepare($con, "SELECT marks, rank FROM marks WHERE class_id = ? AND student_id = ? AND term_id = ? AND subject_id = ? AND assessment = '3' LIMIT 1");
             if ($examStmt) {
               mysqli_stmt_bind_param($examStmt, 'iiii', $class_id, $student_id, $term, $subject_id);
               mysqli_stmt_execute($examStmt);
               $er = mysqli_stmt_get_result($examStmt);
               if ($er && mysqli_num_rows($er) > 0) {
                 $ed = mysqli_fetch_assoc($er);
                 $exammark1 = isset($ed['marks']) ? (int)$ed['marks'] : 0;
                 $rank = isset($ed['rank']) ? (int)$ed['rank'] : 0;
                 if ($rank > 0) {
                   $exammark = round(($exammark1 / $rank) * 100);
                 }
               }
               mysqli_stmt_close($examStmt);
             }
             echo htmlspecialchars($exammark . '%', ENT_QUOTES);

           ?>
              </td>
              <td>
                <?php 
                 if(($exammark>=90)&&($exammark<=100)){       echo 'A*';     }
              if(($exammark>=80)&&($exammark<=89)){       echo 'A';     }
              if(($exammark>=70)&&($exammark<=79)){       echo 'B+';     }
              if(($exammark>=60)&&($exammark<=69)){       echo 'B';     }
              if(($exammark>=50)&&($exammark<=59)){       echo 'C';     }
              if(($exammark>=45)&&($exammark<=49)){       echo 'D';     }
              if($exammark<45){       echo 'F';     }
                          
                ?>
              </td>
              <td>
                <?php
            $finalmark=round(($exammark+$averagemarks)/2);
            echo htmlspecialchars($finalmark.'%', ENT_QUOTES);
                ?>
              </td>
          </tr>
         <?php }
         if ($subStmt) mysqli_stmt_close($subStmt);
         ?>
                    </tbody>
                                    </table>
 <?php }  else { ?>
                        <div class="alert alert-danger">Oops!! No Marks Added Yet</div>
<?php } ?>
                     
                                      
                           
              </div>
              </section>
                          </div>  
                         
                       </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
      <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
  
</body>

</html>
 