<?php
include '../includes/conn.php';
 if(!isset($_SESSION['teachersys'])){
   header('Location:login.php');
   exit;
 }
?>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Past Papers | School Manager</title>

    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>

<body>
<section>
   <?php include 'nav.php'; ?>

     <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-12">
                              <section class="panel">
                                          <header class="panel-heading">
                    Past Papers
                    
                    </header>
                          <div class="panel-body">
                          <table  class="display table  table-striped" id="dynamic-table">
                   <thead>
                                        <tr>
                                              <th>Title</th>
                                                <th>Class</th>
                                              <th>Subject</th>
                                              <th>Added By</th>
                                              <th>Added on</th>                                          
                                              <th>Action</th>
                                                             </tr>
                                    </thead>
                    <tbody>
            <?php
                // Single query using JOINs to avoid per-row queries
                $sql = "SELECT p.pastpaper_id, p.title, p.ext, p.timestamp,
                               c.class AS class_name, s.subject AS subject_name,
                               t.fullname AS teacher_name
                        FROM pastpapers p
                        LEFT JOIN classes c ON p.class_id = c.class_id
                        LEFT JOIN subjects s ON p.subject_id = s.subject_id
                        LEFT JOIN teachers t ON p.teacher_id = t.teacher_id
                        WHERE p.status = 1";
                $stmt = mysqli_prepare($con, $sql);
                if ($stmt) {
                    mysqli_stmt_execute($stmt);
                    $result = mysqli_stmt_get_result($stmt);
                } else {
                    $result = null;
                }

                if (!empty($result) && mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_assoc($result)) {
                        $pastpaper_id = isset($row['pastpaper_id']) ? (int)$row['pastpaper_id'] : 0;
                        $title = $row['title'] ?? '';
                        $ext = $row['ext'] ?? '';
                        $timestamp = isset($row['timestamp']) ? (int)$row['timestamp'] : 0;
                        $class2 = $row['class_name'] ?? '';
                        $subject2 = $row['subject_name'] ?? '';
                        $fname = $row['teacher_name'] ?? '';
            ?>
                     <tr class="gradeA">
                                            <td><?php echo htmlspecialchars($title, ENT_QUOTES); ?></td>
                                            <td><?php echo htmlspecialchars($class2, ENT_QUOTES); ?></td>
                                              <td><?php echo htmlspecialchars($subject2, ENT_QUOTES); ?></td>
                                              <td><?php echo htmlspecialchars($fname, ENT_QUOTES); ?></td>
                                              <td><?php echo htmlspecialchars(date('d/M/Y', $timestamp), ENT_QUOTES); ?></td>
                                              <td>
                                                <?php $fileName = md5((string)$pastpaper_id) . '.' . preg_replace('/[^a-zA-Z0-9]/', '', $ext); ?>
                                                <a href="<?php echo htmlspecialchars(BASE_URL . '/images/pastpapers/' . $fileName, ENT_QUOTES); ?>" class="btn btn-success btn-xs" target="_blank">View</a>
                                                <a href="editpaper?id=<?php echo rawurlencode((string)$pastpaper_id); ?>" class="btn btn-info btn-xs">Edit</a>
                                                <a href="removepaper?id=<?php echo rawurlencode((string)$pastpaper_id); ?>" class="btn btn-danger btn-xs" onclick="return confirm('You are about To Remove this Item. Are you sure you want to proceed?')">Remove</a>
                                              </td>
                                        </tr>
            <?php
                    }
                }
                if ($stmt) mysqli_stmt_close($stmt);
            ?>
                    </tbody>
                                    </table>

                       </div>
                             </section>
                          </div>
   
        </div>
    
        </section>
    </div>
    <!-- main content end-->
</section>

<script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>

</html>