<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

// Validate GET params
$sub = filter_input(INPUT_GET, 'sub', FILTER_VALIDATE_INT);
$cl = filter_input(INPUT_GET, 'cl', FILTER_VALIDATE_INT);
if (!$sub || !$cl) {
  header('Location: index.php');
  exit;
}

// fetch class
$class = '';
$class_id1 = 0;
$category_id = 0;
$cstmt = mysqli_prepare($con, "SELECT class, class_id, category_id FROM classes WHERE class_id = ? LIMIT 1");
if ($cstmt) {
  mysqli_stmt_bind_param($cstmt, 'i', $cl);
  mysqli_stmt_execute($cstmt);
  $cres = mysqli_stmt_get_result($cstmt);
  if ($cres && mysqli_num_rows($cres) > 0) {
    $crow = mysqli_fetch_assoc($cres);
    $class = $crow['class'] ?? '';
    $class_id1 = isset($crow['class_id']) ? (int)$crow['class_id'] : 0;
    $category_id = isset($crow['category_id']) ? (int)$crow['category_id'] : 0;
  }
  mysqli_stmt_close($cstmt);
}

// fetch subject
$subject = '';
$subject_id1 = 0;
$sstmt = mysqli_prepare($con, "SELECT subject, subject_id FROM subjects WHERE subject_id = ? LIMIT 1");
if ($sstmt) {
  mysqli_stmt_bind_param($sstmt, 'i', $sub);
  mysqli_stmt_execute($sstmt);
  $sres = mysqli_stmt_get_result($sstmt);
  if ($sres && mysqli_num_rows($sres) > 0) {
    $srow = mysqli_fetch_assoc($sres);
    $subject = $srow['subject'] ?? '';
    $subject_id1 = isset($srow['subject_id']) ? (int)$srow['subject_id'] : 0;
  }
  mysqli_stmt_close($sstmt);
}


?>
<html>

<head>

  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title><?php echo $subject . ' : ' . $class; ?> | School Manager</title>

  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>

<body>
  <section>
    <?php include 'nav.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">

        <div class="col-lg-12">
          <?php
          // get class_subject id
          $class_sub_id = 0;
          $cs_stmt = mysqli_prepare($con, "SELECT class_sub_id FROM class_subjects WHERE class_id = ? AND subject_id = ? LIMIT 1");
          if ($cs_stmt) {
            mysqli_stmt_bind_param($cs_stmt, 'ii', $cl, $sub);
            mysqli_stmt_execute($cs_stmt);
            $csres = mysqli_stmt_get_result($cs_stmt);
            if ($csres && mysqli_num_rows($csres) > 0) {
              $csrow = mysqli_fetch_assoc($csres);
              $class_sub_id = isset($csrow['class_sub_id']) ? (int)$csrow['class_sub_id'] : 0;
            }
            mysqli_stmt_close($cs_stmt);
          }

          if ($category_id == 3) { ?>
            <a href="addlongtermplan?id=<?php echo htmlspecialchars($class_sub_id, ENT_QUOTES); ?>" class="btn btn-info">Add  Plan</a><br /><br />
          <?php } else { ?>
            <a href="addlongtermplan?id=<?php echo htmlspecialchars($class_sub_id, ENT_QUOTES); ?>&amp;sub=<?php echo htmlspecialchars($sub, ENT_QUOTES); ?>&amp;cl=<?php echo htmlspecialchars($cl, ENT_QUOTES); ?>" class="btn btn-info">Add Plan</a><br /><br />
          <?php } ?>
          <section class="panel">
            <header class="panel-heading">
              <?php echo $subject . ' : ' . $class; ?> Long Term Plans
            </header>
            <div class="panel-body">
              <table class="display table  table-striped" id="dynamic-table">
                <thead>
                  <tr>
                    <th>Term</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $teacherId = isset($_SESSION['teachersys']) ? (int)$_SESSION['teachersys'] : 0;
                  $lp_stmt = mysqli_prepare($con, "SELECT long_term_id, teacher_id, term FROM longterm_plans WHERE class_sub_id = ? AND teacher_id = ? AND status = 1 ORDER BY long_term_id DESC");
                  if ($lp_stmt) {
                    mysqli_stmt_bind_param($lp_stmt, 'ii', $class_sub_id, $teacherId);
                    mysqli_stmt_execute($lp_stmt);
                    $lp_res = mysqli_stmt_get_result($lp_stmt);

                    // prepare financialterms stmt
                    $ft_stmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE status = 1 AND financialterm_id = ? LIMIT 1");

                    while ($row = mysqli_fetch_assoc($lp_res)) {
                      $weeklyplan_id = isset($row['long_term_id']) ? (int)$row['long_term_id'] : 0;
                      $term_value = isset($row['term']) ? (int)$row['term'] : 0;

                      $term = '';
                      $year = '';
                      if ($ft_stmt) {
                        mysqli_stmt_bind_param($ft_stmt, 'i', $term_value);
                        mysqli_stmt_execute($ft_stmt);
                        $ft_res = mysqli_stmt_get_result($ft_stmt);
                        if ($ft_res && mysqli_num_rows($ft_res) > 0) {
                          $ft_row = mysqli_fetch_assoc($ft_res);
                          $term = $ft_row['term'] ?? '';
                          $year = $ft_row['year'] ?? '';
                        }
                      }
                  ?>
                    <tr class="gradeA">
                      <td>Term <?php echo htmlspecialchars($term, ENT_QUOTES); ?></td>
                      <td><a href="longtermplan?id=<?php echo htmlspecialchars($weeklyplan_id, ENT_QUOTES); ?>" class="btn btn-success btn-xs">Details</a>
                        <a href="removelongtermplan?id=<?php echo htmlspecialchars($weeklyplan_id, ENT_QUOTES); ?>" class="btn btn-danger btn-xs" onclick="return confirm_delete<?php echo $weeklyplan_id; ?>()">Remove</a>
                      </td>
                    </tr>
                    <script type="text/javascript">
                      function confirm_delete<?php echo $weeklyplan_id; ?>() {
                        return confirm('You are about To Remove this Student. Are you sure you want to proceed?');
                      }
                    </script>
                  <?php }
                    if ($ft_stmt) mysqli_stmt_close($ft_stmt);
                    mysqli_stmt_close($lp_stmt);
                  } ?>
                </tbody>
              </table>

            </div>
          </section>
        </div>

      </div>

    </section>
    </div>
    <!-- main content end-->
  </section>

  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
  <!--common scripts for all pages-->
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>

</html>