<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location:login');
  exit;
}
$teacher_session_id = (int)($_SESSION['teachersys'] ?? 0);
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="keywords" content="admin, dashboard, bootstrap, template, flat, modern, theme, responsive, fluid, retina, backend, html5, css, css3">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Home</title>
  <link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/bootstrap-fullcalendar.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->

  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/prettyphoto/css/prettyPhoto.css" type="text/css" media="screen" title="prettyPhoto main stylesheet" charset="utf-8" />
  <script src='<?php echo BASE_URL; ?>/js/fullcalendar/moment.min.js'></script>
  <script src='<?php echo BASE_URL; ?>/js/fullcalendar/jquery-ui.custom.min.js'></script>
  <script src='<?php echo BASE_URL; ?>/js/fullcalendar/fullcalendar.min.js'></script>
  <script>
    $(document).ready(function() {
      /* initialize the external events
      -----------------------------------------------------------------*/
      $.ajax({
        url: '<?php echo BASE_URL; ?>/getevents.php',
        type: 'POST',
        data: 'type=fetch',
        async: false,
        success: function(response) {
          json_events = response;
        }
      });
      /* initialize the calendar
      -----------------------------------------------------------------*/
      var date = new Date();
      var d = date.getDate();
      var m = date.getMonth();
      var y = date.getFullYear();

      $('#calendar').fullCalendar({
        header: {
          left: 'prev,next today',
          center: 'title',
          right: 'month,agendaWeek,agendaDay'
        },
        buttonIcons: false, // show the prev/next text
        weekNumbers: true,
        navLinks: true, // can click day/week names to navigate views
        editable: true,
        eventLimit: true, // allow "more" link when too many events

        events: JSON.parse(json_events)
      });


    });
  </script>
</head>

<body class="sticky-header">

  <section>
    <?php include 'nav.php'; ?>


    <!--body wrapper start-->
    <div class="wrapper">
      <div class="row">
        <div class="col-lg-4">
          <section class="panel">

            <div class="panel-body">
              <?php
              $employee = mysqli_query($con, "SELECT teacher_id,fullname,gender,designation,status,ext,email,phone,class_id,classteacher FROM teachers WHERE teacher_id='{$teacher_session_id}' LIMIT 1");
              $teacher_id = $teacher_session_id;
              $fullname = '';
              $gender = '';
              $design = '';
              $status = '';
              $ext = '';
              $email = '';
              $phone = '';
              $class_id = 0;
              $classteacher = '';
              if ($employee && $row = mysqli_fetch_assoc($employee)) {
                $teacher_id = (int)($row['teacher_id'] ?? $teacher_id);
                $fullname = $row['fullname'] ?? '';
                $gender = $row['gender'] ?? '';
                $design = $row['designation'] ?? '';
                $status = $row['status'] ?? '';
                $ext = $row['ext'] ?? '';
                $email = $row['email'] ?? '';
                $phone = $row['phone'] ?? '';
                $class_id = (int)($row['class_id'] ?? 0);
                $classteacher = $row['classteacher'] ?? '';
              }
              $classname = 'Not Assigned';
              if ($class_id > 0) {
                $getclasses = mysqli_query($con, "SELECT class_id,class FROM classes WHERE class_id='{$class_id}' LIMIT 1");
                if ($getclasses && $row2 = mysqli_fetch_assoc($getclasses)) {
                  $class_id = (int)($row2['class_id'] ?? $class_id);
                  $classname = $row2['class'] ?? 'Not Assigned';
                }
              }
              if ($ext == '') {  ?>
                <img alt="image" class="img-responsive" src="<?php echo BASE_URL; ?>/images/avatar.png" width="100%">
              <?php
              } else { ?>
                <img alt="image" class="img-responsive" src="<?php echo BASE_URL; ?>/images/teachers/<?php echo htmlspecialchars(md5($teacher_id) . '.' . $ext . '?' .  time()); ?>" width="100%">
              <?php   } ?>
            </div>
          </section>

        </div>
        <div class="col-lg-7">
          <section class="panel">
            <header class="panel-heading">
              Teacher Information
            </header>
            <div class="panel-body">
              <table class="display table  table-striped" id="dynamic-table">

                <tbody>

                  <tr class="gradeA">
                    <th>Full Name</th>
                    <td><?php echo htmlspecialchars($fullname); ?></td>
                  </tr>
                  <tr class="gradeA">
                    <th>Subjects Taught</th>
                    <td>
                      <?php
                      $teacher_subjects = mysqli_query($con, "SELECT * FROM teacher_subjects WHERE teacher_id='{$teacher_session_id}'");
                      if ($teacher_subjects) {
                        while ($row = mysqli_fetch_assoc($teacher_subjects)) {
                          $class_sub_id = (int)($row['class_sub_id'] ?? 0);
                          $class_subjects = mysqli_query($con, "SELECT * FROM class_subjects WHERE class_sub_id='{$class_sub_id}'");
                          if ($class_subjects) {
                            while ($row1 = mysqli_fetch_assoc($class_subjects)) {
                              $class_id_local = (int)($row1['class_id'] ?? 0);
                              $subject_id = (int)($row1['subject_id'] ?? 0);
                              $class = '';
                              $getclasses = mysqli_query($con, "SELECT class FROM classes WHERE class_id='{$class_id_local}' LIMIT 1");
                              if ($getclasses && $row2 = mysqli_fetch_assoc($getclasses)) {
                                $class = $row2['class'] ?? '';
                              }
                              $subject = '';
                              $getsubjects = mysqli_query($con, "SELECT subject FROM subjects WHERE subject_id='{$subject_id}' LIMIT 1");
                              if ($getsubjects && $row3 = mysqli_fetch_assoc($getsubjects)) {
                                $subject = $row3['subject'] ?? '';
                              }
                              echo htmlspecialchars($class . ':' . $subject) . '&nbsp; ,&nbsp;';
                            }
                          }
                        }
                      }
                      ?>
                    </td>
                  </tr>

                  <tr class="gradeA">
                    <th> Gender</th>
                    <td><?php echo htmlspecialchars($gender); ?></td>
                  </tr>
                  <tr class="gradeA">
                    <th> Class Teacher</th>
                    <td><?php if ($classteacher == 'yes') {
                          echo htmlspecialchars($classname);
                        } else {
                          echo 'NO';
                        } ?></td>
                  </tr>
                  <tr class="gradeA">
                    <th> Phone</th>
                    <td><?php echo htmlspecialchars($phone); ?></td>
                  </tr>
                  <tr class="gradeA">
                    <th>Email</th>
                    <td><?php echo htmlspecialchars($email); ?></td>
                  </tr>


                </tbody>
              </table>

            </div>
          </section>

        </div>

      </div>
      <div class="row">

        <div class="col-lg-10">
          <section class="panel">
            <header class="panel-heading">
              Teacher TimeTable
            </header>

            <div class="panel-body">
              <?php 
              // Get the days
              $getdays = mysqli_query($con, "SELECT day,short FROM days");

              if ($getdays && mysqli_num_rows($getdays) > 0) {
              
              ?>
            <table class="display table  table-bordered" style="margin-bottom: 20px;">
                <tr>
                    <th>Day</th>
                    <th>Start Time</th>
                    <th>End Time</th>
                    <th>Activity</th>
                    <th>Class</th>
                </tr>
                <?php 
                 while ($roww = mysqli_fetch_assoc($getdays)) {
                  $day = $roww['day'] ?? '';
                  $short = $roww['short'] ?? '';
                  
                  // Get the timetable for each day
                  $timetable = mysqli_query($con, "SELECT * FROM timetables WHERE day='{$short}' AND status=1 ORDER BY position");
          
                  if (mysqli_num_rows($timetable) > 0) {
                      $firstRow = true; // To merge the day cell for each day's timetable rows
                      
                      while ($row = mysqli_fetch_assoc($timetable)) {
                        $starttime = $row['starttime'] ?? '';
                $endtime = $row['endtime'] ?? '';
                $activity = $row['activity'] ?? '';
                $class_id = (int)($row['class_id'] ?? 0);
                
                // Fetch class and subject information
        $class_subjects = mysqli_query($con, "SELECT subject_id,class_id FROM class_subjects WHERE class_sub_id='{$activity}'");
        if ($class_subjects && mysqli_num_rows($class_subjects) > 0) {
          $row1 = mysqli_fetch_assoc($class_subjects);
          $subject_id = (int)($row1['subject_id'] ?? 0);
          $class_id = (int)($row1['class_id'] ?? $class_id);

          // Get subject name
          $getsubjects = mysqli_query($con, "SELECT subject FROM subjects WHERE subject_id='{$subject_id}' LIMIT 1");
          $subject = '';
          if ($getsubjects && $rsub = mysqli_fetch_assoc($getsubjects)) {
            $subject = $rsub['subject'] ?? '';
          }
        } else {
          $subject = $activity;
        }
                    // Get class name
          $getclass = mysqli_query($con, "SELECT class FROM classes WHERE class_id='{$class_id}' LIMIT 1");
          $class = '';
          if ($getclass && $rclass = mysqli_fetch_assoc($getclass)) {
            $class = $rclass['class'] ?? '';
          }

                    // // Get stream name
                    // $getstream = mysqli_query($con, "SELECT * FROM streams WHERE stream_id='$stream_id'");
                    // $stream = (mysqli_num_rows($getstream) > 0) ? mysqli_fetch_array($getstream)['stream'] : '';

                    // Display timetable row
          echo '<tr>';
          if ($firstRow) {
            echo '<td rowspan="' . mysqli_num_rows($timetable) . '">' . htmlspecialchars($day) . '<br/>
             <a href="edittimetable?cl='. (int)$class_id.'&&st=0&&day='.htmlspecialchars($short).'" class="btn btn-sm btn-danger pull-right">Edit</a>
            </td>';
            $firstRow = false;
          }
          echo '<td>' . htmlspecialchars($starttime) . '</td>
              <td>' . htmlspecialchars($endtime) . '</td>
              <td>' . htmlspecialchars($subject) . '</td>
              <td>' . htmlspecialchars($class) . '</td>
            </tr>';
               
            }
        } else {
            // Display "Coming Soon" message if no timetable found for the day
            echo '<tr>
                    <td>' . $day . '</td>
                    <td colspan="5"><div class="alert alert-danger" style="width: 100%">Timetable for ' . $day . ' Coming Soon</div></td>
                  </tr>';
        }
    }
                
                ?>
            </table>
            <?php } else {
                echo "No timetable available";
            } ?>
            </div>

          </section>

        </div>

      </div>

    </div>
    <!-- main content end-->
  </section>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
  <!--common scripts for all pages-->
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
  <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>

</body>

</html>