<?php
include '../includes/conn.php';

// require logged-in teacher and class teacher privilege
if (!isset($_SESSION['teachersys']) || ($_SESSION['classteacher'] ?? '') !== 'yes') {
    header('Location: login.php');
    exit;
}

// validate subject id and class id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$classId = isset($_SESSION['class_id']) ? (int)$_SESSION['class_id'] : 0;

if (!$id || !$classId) {
    // if missing data, return to referrer or index
    $back = $_SERVER['HTTP_REFERER'] ?? 'index.php';
    header('Location: ' . $back);
    exit;
}

// prepared update to hide the subject
$stmt = mysqli_prepare($con, "UPDATE subjects SET status = 0 WHERE subject_id = ? AND class_id = ?");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'ii', $id, $classId);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
}

$back = $_SERVER['HTTP_REFERER'] ?? 'index.php';
header('Location: ' . $back);
exit;
?>