<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

// Validate id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location: subjecttermreports.php');
  exit;
}

// Fetch subject term report for this teacher
$subjecttermreport_id = null;
$class_id = null;
$report = '';
$timestamp = null;
$teacher_id = null;
$student_id = null;
$term_id = null;
$class2 = '';
$category_id = null;
$fname = '';
$term2 = '';
$year = '';
$fullname = '';

$rstmt = mysqli_prepare($con, "SELECT * FROM subjecttermreports WHERE teacher_id = ? AND subjecttermreport_id = ?");
if ($rstmt) {
  $tid = (int)$_SESSION['teachersys'];
  mysqli_stmt_bind_param($rstmt, 'ii', $tid, $id);
  mysqli_stmt_execute($rstmt);
  $rres = mysqli_stmt_get_result($rstmt);
  if ($rres && mysqli_num_rows($rres) > 0) {
    $row = mysqli_fetch_assoc($rres);
    $subjecttermreport_id = $row['subjecttermreport_id'];
    $class_id = $row['class_id'];
    $report = $row['report'];
    $timestamp = $row['timestamp'];
    $teacher_id = $row['teacher_id'];
    $student_id = $row['student_id'];
    $term_id = $row['term_id'];
  }
  mysqli_stmt_close($rstmt);
}

// fetch class
if ($class_id) {
  $cstmt = mysqli_prepare($con, "SELECT `class`, category_id FROM classes WHERE class_id = ?");
  if ($cstmt) {
    mysqli_stmt_bind_param($cstmt, 'i', $class_id);
    mysqli_stmt_execute($cstmt);
    $cres = mysqli_stmt_get_result($cstmt);
    if ($cres && mysqli_num_rows($cres) > 0) {
      $crow = mysqli_fetch_assoc($cres);
      $class2 = $crow['class'] ?? '';
      $category_id = $crow['category_id'] ?? null;
    }
    mysqli_stmt_close($cstmt);
  }
}

// fetch teacher name
if ($teacher_id) {
  $tstmt = mysqli_prepare($con, "SELECT fullname FROM teachers WHERE teacher_id = ?");
  if ($tstmt) {
    mysqli_stmt_bind_param($tstmt, 'i', $teacher_id);
    mysqli_stmt_execute($tstmt);
    $tres = mysqli_stmt_get_result($tstmt);
    if ($tres && mysqli_num_rows($tres) > 0) {
      $trow = mysqli_fetch_assoc($tres);
      $fname = $trow['fullname'] ?? '';
    }
    mysqli_stmt_close($tstmt);
  }
}

// fetch term
if ($term_id) {
  $tstmt2 = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE financialterm_id = ?");
  if ($tstmt2) {
    mysqli_stmt_bind_param($tstmt2, 'i', $term_id);
    mysqli_stmt_execute($tstmt2);
    $tres2 = mysqli_stmt_get_result($tstmt2);
    if ($tres2 && mysqli_num_rows($tres2) > 0) {
      $trow2 = mysqli_fetch_assoc($tres2);
      $term2 = $trow2['term'] ?? '';
      $year = $trow2['year'] ?? '';
    }
    mysqli_stmt_close($tstmt2);
  }
}

// fetch student fullname
if ($student_id) {
  $sstmt = mysqli_prepare($con, "SELECT fullname FROM students WHERE student_id = ?");
  if ($sstmt) {
    mysqli_stmt_bind_param($sstmt, 'i', $student_id);
    mysqli_stmt_execute($sstmt);
    $sres = mysqli_stmt_get_result($sstmt);
    if ($sres && mysqli_num_rows($sres) > 0) {
      $srow = mysqli_fetch_assoc($sres);
      $fullname = $srow['fullname'] ?? '';
    }
    mysqli_stmt_close($sstmt);
  }
}
?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Edit Subject Report-School Manager</title>
          <script src="<?php echo BASE_URL; ?>/ckeditor/ckeditor.js"></script>
   <link rel="stylesheet" href="<?php echo BASE_URL; ?>/ckeditor/samples/sample.css">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
     <link href="<?php echo BASE_URL; ?>/css/chosen/chosen.css" rel="stylesheet">

</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
           
    <div class="col-lg-10">
                      <section class="panel">
                    <header class="panel-heading">
                  Edit <?php echo $fullname;?>'s  End of Term <?php echo $term2;?> Report
                    </header>
                          <div class="panel-body">      
      <?php
            if (isset($_POST['report'], $_POST['term'])) {
              $p_report = trim($_POST['report']);
              $p_term = filter_var($_POST['term'], FILTER_VALIDATE_INT);
              $errors = [];
              if (empty($p_report) || empty($p_term)) {
                $errors[] = 'Enter All Fields to Proceed';
              }

              if (!empty($errors)) {
                foreach ($errors as $error) {
?>
 <div class="alert alert-danger"><?php echo htmlspecialchars($error, ENT_QUOTES); ?></div>
<?php
                }
              } else {
                $ust = mysqli_prepare($con, "UPDATE subjecttermreports SET term_id = ?, report = ? WHERE teacher_id = ? AND subjecttermreport_id = ?");
                if ($ust) {
                  $tid = (int)$_SESSION['teachersys'];
                  mysqli_stmt_bind_param($ust, 'isii', $p_term, $p_report, $tid, $id);
                  mysqli_stmt_execute($ust);
                  mysqli_stmt_close($ust);
                }
                echo '<div class="alert alert-success">Report Successfully Edited</div>';
              }
            }
                        
            ?>
                        
<form method="POST"  name='form' class="form" action=""  enctype="multipart/form-data">
      <div class="form-group">
                                  <label class="control-label">*Term and Year</label>                                
                    <select name="term" class="form-control">
                                               <?php
                $terms_list = [];
                $tall = mysqli_prepare($con, "SELECT financialterm_id, term, year FROM financialterms WHERE status = 1");
                if ($tall) {
                  mysqli_stmt_execute($tall);
                  $tallres = mysqli_stmt_get_result($tall);
                  if ($tallres) {
                    while ($trow = mysqli_fetch_assoc($tallres)) {
                      $terms_list[] = $trow;
                    }
                  }
                  mysqli_stmt_close($tall);
                }
                foreach ($terms_list as $trow) {
                  ?>
                      <option value="<?php echo htmlspecialchars($trow['financialterm_id'], ENT_QUOTES); ?>" <?php if ($trow['financialterm_id'] == $term_id) { echo 'selected="selected"'; } ?>><?php echo 'Term ' . htmlspecialchars($trow['term'], ENT_QUOTES) . ' ' . htmlspecialchars($trow['year'], ENT_QUOTES); ?></option>
                <?php } ?>
                    </select>                                                                         
                                </div>
            
                         
       
                                               <div class="form-group">
                                      <label class="control-label">Report</label>                                
                                   <textarea class="ckeditor" id="editor1" name="report"><?php echo htmlspecialchars($report, ENT_QUOTES); ?></textarea>                                             
                                </div>
                                  
                                                     <div class="hr-line-dashed"></div>                            
                                                                                                  
                                <div class="form-group">                                                                    
                                        <button class="btn btn-primary" type="submit">Edit</button>
                                                                 </div>
                            </form>
                       </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
 <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/chosen/chosen.jquery.js"></script>
<script>
    var config = {
                '.chosen-select'           : {},
                '.chosen-select-deselect'  : {allow_single_deselect:true},
                '.chosen-select-no-single' : {disable_search_threshold:10},
                '.chosen-select-no-results': {no_results_text:'Oops, nothing found!'},
                '.chosen-select-width'     : {width:"95%"}
            }
            for (var selector in config) {
                $(selector).chosen(config[selector]);
            }
            </script>

  
</body>

</html>
 