<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys']) || ($_SESSION['classteacher'] != 'yes')) {
    header('Location: login.php');
    exit;
}

// validate id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
    header('Location: subjects.php');
    exit;
}
?>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <title>Edit  Learning Area- School Manager</title>
    <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">
    <!--<link href="css/plugins/iCheck/custom.css" rel="stylesheet">-->
    <link href="<?php echo BASE_URL; ?>/css/animate.css" rel="stylesheet">
      <link href="<?php echo BASE_URL; ?>/css/plugins/chosen/chosen.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
</head>
<body>
    
    <div id="wrapper">
        <?php include 'nav.php'; ?>
        <div id="page-wrapper" class="gray-bg">
        <div class="row border-bottom">
        <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
        <div class="navbar-header">
            <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
          
        </div>
            <ul class="nav navbar-top-links navbar-right">
               
                <li>
                    <a href="logout">
                        <i class="fa fa-sign-out"></i> Log out
                    </a>
                </li>
            </ul>

        </nav>
        </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2>Edit Learning area</h2>
                    <ol class="breadcrumb">
                        <li>              <a href=""><i class="fa fa-home"></i> Home</a>                    </li>
                                              <li class="active">
                            <strong>Edit Learning area</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">
                </div>
            </div>
        <div class="wrapper wrapper-content">
                                <div class="row">
                <div class="col-lg-8">
                    <div class="ibox float-e-margins">
                        <div class="ibox-title">
                            <h5>Edit  Learning<small>All  fields marked (*) shouldn't be left blank</small></h5>                           
                        </div>
                        <div class="ibox-content">
                            <?php
                            if (isset($_POST['subject'], $_POST['type'])) {
                                $p_subject = trim($_POST['subject']);
                                $p_type = filter_var($_POST['type'], FILTER_SANITIZE_STRING);
                                $errors = [];
                                if (empty($p_subject) || empty($p_type)) {
                                    $errors[] = 'All fields are required';
                                }
                                if (!empty($errors)) {
                                    foreach ($errors as $e) {
                                        echo '<div class="alert alert-danger">' . htmlspecialchars($e, ENT_QUOTES) . '</div>';
                                    }
                                } else {
                                    $ust = mysqli_prepare($con, "UPDATE subjects SET subject = ?, type = ? WHERE subject_id = ?");
                                    if ($ust) {
                                        mysqli_stmt_bind_param($ust, 'ssi', $p_subject, $p_type, $id);
                                        mysqli_stmt_execute($ust);
                                        mysqli_stmt_close($ust);
                                    }
                                    echo '<div class="alert alert-success"><i class="fa fa-check"></i> Subject Successfully Edited</div>';
                                }
                            }

                            // fetch subject
                            $subject = '';
                            $type = '';
                            $creator = '';
                            $subjectsStmt = mysqli_prepare($con, "SELECT subject_id, subject, type, creator FROM subjects WHERE subject_id = ?");
                            if ($subjectsStmt) {
                                mysqli_stmt_bind_param($subjectsStmt, 'i', $id);
                                mysqli_stmt_execute($subjectsStmt);
                                $sres = mysqli_stmt_get_result($subjectsStmt);
                                if ($sres && mysqli_num_rows($sres) > 0) {
                                    $row = mysqli_fetch_assoc($sres);
                                    $subject_id = $row['subject_id'];
                                    $subject = $row['subject'] ?? '';
                                    $type = $row['type'] ?? '';
                                    $creator = $row['creator'] ?? '';
                                }
                                mysqli_stmt_close($subjectsStmt);
                            }

    // fetch class info for current session class
    $class = '';
    $category_id = null;
    $getclassesStmt = mysqli_prepare($con, "SELECT class, category_id FROM classes WHERE class_id = ?");
    if ($getclassesStmt) {
        $cid = (int)$_SESSION['class_id'];
        mysqli_stmt_bind_param($getclassesStmt, 'i', $cid);
        mysqli_stmt_execute($getclassesStmt);
        $cres = mysqli_stmt_get_result($getclassesStmt);
        if ($cres && mysqli_num_rows($cres) > 0) {
            $row3 = mysqli_fetch_assoc($cres);
            $class = $row3['class'] ?? '';
            $category_id = $row3['category_id'] ?? null;
        }
        mysqli_stmt_close($getclassesStmt);
    }
?>
                        
     <form method="post" name='form' class="form" action=""  enctype="multipart/form-data">                              
                                     
                                  <div class="form-group">
                                      <label class="control-label"> *Learning Area name</label>
                                      <input type="text" name="subject" class="form-control "  placeholder="Enter  name" value="<?php echo htmlspecialchars($subject, ENT_QUOTES); ?>" required="required">
                                                               
                                </div>
           <div class="form-group"><label class="control-label"> *Type</label>
                  <select name="type" class="form-control ">
                      <option value="<?php echo htmlspecialchars($type, ENT_QUOTES); ?>" selected="selected"><?php echo htmlspecialchars($type, ENT_QUOTES); ?></option>
                       <?php
                                                      if ($category_id == 3) {
                                                          ?>
                      <option value="prime">Prime Areas</option>
                      <option value="specific">Specific Areas</option>
                                                      <?php } else { ?>
                      <option value="subject">Academic Subject</option>
                      <option value="session">Spark Session</option>
                                                      <?php } ?>
                  </select>
                                                                   
                                </div>
                              
                                                        <div class="hr-line-dashed"></div>                           
                                                                                                  
                                <div class="form-group">                                                                   
                                        <button class="btn btn-primary" type="submit">Edit</button>
                                                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>


    </div>

    <!-- Mainly scripts -->
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/plugins/chosen/chosen.jquery.js"></script>
    <!-- iCheck -->
   <script language="JavaScript" src="<?php echo BASE_URL; ?>/js/gen_validatorv4.js" type="text/javascript"></script>
</body>

</html>
 <script type="text/javascript">
     
                    var config = {
                '.chosen-select'           : {},
                '.chosen-select-deselect'  : {allow_single_deselect:true},
                '.chosen-select-no-single' : {disable_search_threshold:10},
                '.chosen-select-no-results': {no_results_text:'Oops, nothing found!'},
                '.chosen-select-width'     : {width:"95%"}
            }
            for (var selector in config) {
                $(selector).chosen(config[selector]);
            }

 
</script>