<?php
include '../includes/conn.php';

if (!isset($_SESSION['teachersys'])) {
   header('Location: login.php');
   exit;
}

// Validate GET id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
   header('Location: reports.php');
   exit;
}
?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Edit Report-School Manager</title>
          <script src="<?php echo BASE_URL; ?>/ckeditor/ckeditor.js"></script>
   <link rel="stylesheet" href="<?php echo BASE_URL; ?>/ckeditor/samples/sample.css">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
           
    <div class="col-lg-10">
                      <section class="panel">
                    <header class="panel-heading">
                  Edit Report
                    </header>
                          <div class="panel-body">      
         <?php
                   if (isset($_POST['report'], $_POST['term'])) {
                      $report_in = trim($_POST['report']);
                      $term_in = filter_var($_POST['term'], FILTER_VALIDATE_INT);
                      $errors = [];
                      if (empty($report_in) || empty($term_in)) {
                         $errors[] = 'Enter All Fields to Proceed';
                      }

                      // check for duplicate report for same teacher and term (excluding current)
                      $checkstmt = mysqli_prepare($con, "SELECT 1 FROM reports WHERE term_id = ? AND teacher_id = ? AND status = 1 AND report_id != ?");
                      if ($checkstmt) {
                         $teacher_id = (int)$_SESSION['teachersys'];
                         mysqli_stmt_bind_param($checkstmt, 'iii', $term_in, $teacher_id, $id);
                         mysqli_stmt_execute($checkstmt);
                         $checkres = mysqli_stmt_get_result($checkstmt);
                         if ($checkres && mysqli_num_rows($checkres) > 0) {
                            $errors[] = 'Report already Added';
                         }
                         mysqli_stmt_close($checkstmt);
                      }

                      if (!empty($errors)) {
                         foreach ($errors as $error) {
?>
 <div class="alert alert-danger"><?php echo htmlspecialchars($error, ENT_QUOTES); ?></div>
<?php
                         }
                      } else {
                         $ust = mysqli_prepare($con, "UPDATE reports SET term_id = ?, report = ? WHERE report_id = ?");
                         if ($ust) {
                            mysqli_stmt_bind_param($ust, 'isi', $term_in, $report_in, $id);
                            mysqli_stmt_execute($ust);
                            mysqli_stmt_close($ust);
                         }
                         echo '<div class="alert alert-success">Report Successfully Edited</div>';
                      }
                   }

      $report_id = null;
      $report = '';
      $timestamp = null;
      $term_id = null;
      // fetch report
      $rstmt = mysqli_prepare($con, "SELECT report_id, report, timestamp, term_id FROM reports WHERE report_id = ?");
      if ($rstmt) {
         mysqli_stmt_bind_param($rstmt, 'i', $id);
         mysqli_stmt_execute($rstmt);
         $rres = mysqli_stmt_get_result($rstmt);
         if ($rres && mysqli_num_rows($rres) > 0) {
            $row2 = mysqli_fetch_assoc($rres);
            $report_id = $row2['report_id'];
            $report = $row2['report'];
            $timestamp = $row2['timestamp'];
            $term_id = $row2['term_id'];
         }
         mysqli_stmt_close($rstmt);
      }

      $term = '';
      $year = '';
      if ($term_id) {
         $tstmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE financialterm_id = ?");
         if ($tstmt) {
            mysqli_stmt_bind_param($tstmt, 'i', $term_id);
            mysqli_stmt_execute($tstmt);
            $tres = mysqli_stmt_get_result($tstmt);
            if ($tres && mysqli_num_rows($tres) > 0) {
               $row1 = mysqli_fetch_assoc($tres);
               $term = $row1['term'];
               $year = $row1['year'];
            }
            mysqli_stmt_close($tstmt);
         }
      }
                        ?>
                        
<form method="POST"  name='form' class="form" action=""  enctype="multipart/form-data">
      <div class="form-group">
                                  <label class="control-label">*Term and Year</label>                                
                              <select name="term" class="form-control">
                                 <option value="<?php echo htmlspecialchars($term_id, ENT_QUOTES); ?>" selected="selected"><?php echo htmlspecialchars($term . ' ' . $year, ENT_QUOTES); ?></option>
                                                                     <?php
                        $terms_list = [];
                        $tall = mysqli_prepare($con, "SELECT financialterm_id, term, year FROM financialterms WHERE status = 1");
                        if ($tall) {
                           mysqli_stmt_execute($tall);
                           $tallres = mysqli_stmt_get_result($tall);
                           if ($tallres) {
                              while ($trow = mysqli_fetch_assoc($tallres)) {
                                 $terms_list[] = $trow;
                              }
                           }
                           mysqli_stmt_close($tall);
                        }
                        foreach ($terms_list as $trow) {
                           ?>
                                 <option value="<?php echo htmlspecialchars($trow['financialterm_id'], ENT_QUOTES); ?>"><?php echo 'Term ' . htmlspecialchars($trow['term'], ENT_QUOTES) . ' ' . htmlspecialchars($trow['year'], ENT_QUOTES); ?></option>
                        <?php } ?>
                              </select>                                                                         
                                </div>
                                               <div class="form-group">
                                      <label class="control-label">Report</label>                                
                                   <textarea class="ckeditor" id="editor1" name="report"><?php echo htmlspecialchars($report, ENT_QUOTES); ?></textarea>                                        
                                                                                            
                                </div>
                                  
                                                     <div class="hr-line-dashed"></div>                            
                                                                                                  
                                <div class="form-group">                                                                    
                                        <button class="btn btn-primary" type="submit">Submit</button>
                                                                 </div>
                            </form>
                       </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
 <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
<script>
  $('#data_1 .input-group.date').datepicker({
                todayBtn: "linked",
                keyboardNavigation: false,
                forceParse: false,
                calendarWeeks: true,
                autoclose: true
            });   
</script>
  
</body>

</html>
 