<?php
include '../includes/conn.php';

if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

// Validate GET id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location: pastpapers');
  exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <title>Edit Past Paper-School Manager</title>
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
           Edit past paper
                    </header>
                          <div class="panel-body">    
      <?php
             if (isset($_POST['class'], $_POST['title'])) {
               $class = trim($_POST['class']);
               $title = trim($_POST['title']);
               $image_name = $_FILES['image']['name'] ?? '';
               $image_size = $_FILES['image']['size'] ?? 0;
               $image_temp = $_FILES['image']['tmp_name'] ?? '';
               $allowed_ext = array('doc', 'docx', 'pdf');
               $errors = array();

               if ((empty($class)) || (empty($title))) {
                 $errors[] = 'All Fields are Required';
               }

               $image_ext = '';
               if (!empty($image_name)) {
                 $imgext = explode('.', $image_name);
                 $imgext2 = end($imgext);
                 $image_ext = strtolower($imgext2);
                 if (!in_array($image_ext, $allowed_ext, true)) {
                   $errors[] = 'File type not allowed';
                 }
                 if ($image_size > 10097152) {
                   $errors[] = 'Maximum file size is 10MB';
                 }
               }

               if (!empty($errors)) {
                 foreach ($errors as $error) {
?>
 <div class="alert alert-danger"><?php echo htmlspecialchars($error, ENT_QUOTES); ?></div>
<?php
                 }
               } else {
                 // parse class and subject
                 $split = explode(',', $class);
                 $class_id = (int)current($split);
                 $subject = (int)end($split);

                 if (!empty($image_name) && !empty($image_ext)) {
                   $ust = mysqli_prepare($con, "UPDATE pastpapers SET class_id = ?, subject_id = ?, title = ?, ext = ? WHERE pastpaper_id = ?");
                   if ($ust) {
                     mysqli_stmt_bind_param($ust, 'iissi', $class_id, $subject, $title, $image_ext, $id);
                     mysqli_stmt_execute($ust);
                     mysqli_stmt_close($ust);
                   }
                   $image_file = md5($id) . '.' . $image_ext;
                   if (!is_dir(__DIR__ . '/../images/pastpapers')) {
                     @mkdir(__DIR__ . '/../images/pastpapers', 0755, true);
                   }
                   move_uploaded_file($image_temp, __DIR__ . "/../images/pastpapers/" . $image_file);
                 } else {
                   $ust = mysqli_prepare($con, "UPDATE pastpapers SET class_id = ?, subject_id = ?, title = ? WHERE pastpaper_id = ?");
                   if ($ust) {
                     mysqli_stmt_bind_param($ust, 'iisi', $class_id, $subject, $title, $id);
                     mysqli_stmt_execute($ust);
                     mysqli_stmt_close($ust);
                   }
                 }
                 echo '<div class="alert alert-success">Past paper Successfully Posted</div>';
               }
             }
                      // fetch pastpaper
                      $pastpaper_id = null;
                      $class_id = null;
                      $title = '';
                      $ext = '';
                      $timestamp = null;
                      $subject_id = null;
                      $teacher_id = null;
                      $class2 = '';
                      $subject2 = '';
                      $fname = '';

                      $ppstmt = mysqli_prepare($con, "SELECT * FROM pastpapers WHERE status = 1 AND pastpaper_id = ?");
                      if ($ppstmt) {
                        mysqli_stmt_bind_param($ppstmt, 'i', $id);
                        mysqli_stmt_execute($ppstmt);
                        $ppres = mysqli_stmt_get_result($ppstmt);
                        if ($ppres && mysqli_num_rows($ppres) > 0) {
                          $row = mysqli_fetch_assoc($ppres);
                          $pastpaper_id = $row['pastpaper_id'];
                          $class_id = $row['class_id'];
                          $title = $row['title'];
                          $ext = $row['ext'];
                          $timestamp = $row['timestamp'];
                          $subject_id = $row['subject_id'];
                          $teacher_id = $row['teacher_id'];
                        }
                        mysqli_stmt_close($ppstmt);
                      }

                      // fetch class name
                      if ($class_id) {
                        $cstmt = mysqli_prepare($con, "SELECT `class`, category_id FROM classes WHERE class_id = ?");
                        if ($cstmt) {
                          mysqli_stmt_bind_param($cstmt, 'i', $class_id);
                          mysqli_stmt_execute($cstmt);
                          $cres = mysqli_stmt_get_result($cstmt);
                          if ($cres && mysqli_num_rows($cres) > 0) {
                            $crow = mysqli_fetch_assoc($cres);
                            $class2 = $crow['class'] ?? '';
                            $category_id = $crow['category_id'] ?? null;
                          }
                          mysqli_stmt_close($cstmt);
                        }
                      }

                      // fetch subject name
                      if ($subject_id) {
                        $sstmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ?");
                        if ($sstmt) {
                          mysqli_stmt_bind_param($sstmt, 'i', $subject_id);
                          mysqli_stmt_execute($sstmt);
                          $sres = mysqli_stmt_get_result($sstmt);
                          if ($sres && mysqli_num_rows($sres) > 0) {
                            $srow = mysqli_fetch_assoc($sres);
                            $subject2 = $srow['subject'] ?? '';
                          }
                          mysqli_stmt_close($sstmt);
                        }
                      }

                      // fetch teacher fullname
                      if ($teacher_id) {
                        $tstmt = mysqli_prepare($con, "SELECT fullname FROM teachers WHERE teacher_id = ?");
                        if ($tstmt) {
                          mysqli_stmt_bind_param($tstmt, 'i', $teacher_id);
                          mysqli_stmt_execute($tstmt);
                          $tres = mysqli_stmt_get_result($tstmt);
                          if ($tres && mysqli_num_rows($tres) > 0) {
                            $trow = mysqli_fetch_assoc($tres);
                            $fname = $trow['fullname'] ?? '';
                          }
                          mysqli_stmt_close($tstmt);
                        }
                      }
                                      ?>
 <form method="POST"  name='form' class="form" action=""  enctype="multipart/form-data">
    <div class="form-group">
         <label class="control-label">* Past Paper Name</label>
         <input type="text" name="title" class="form-control" placeholder="Enter Past paper name" value="<?php echo $title; ?>">
     </div>
                                        <div class="form-group"><label class="control-label">* Class and subject</label>
                                                  <select name='class' class="form-control" >
                            <option value="<?php echo htmlspecialchars($class_id . ',' . $subject_id, ENT_QUOTES); ?>" selected="selected"><?php echo htmlspecialchars($class2 . ':' . $subject2, ENT_QUOTES); ?></option>
                                                    <?php 
                          // fetch teacher_subjects for this teacher
                          $ts_list = [];
                          $tsstmt = mysqli_prepare($con, "SELECT class_sub_id FROM teacher_subjects WHERE teacher_id = ?");
                          if ($tsstmt) {
                            $tid = (int)$_SESSION['teachersys'];
                            mysqli_stmt_bind_param($tsstmt, 'i', $tid);
                            mysqli_stmt_execute($tsstmt);
                            $tsres = mysqli_stmt_get_result($tsstmt);
                            if ($tsres) {
                              while ($trow = mysqli_fetch_assoc($tsres)) {
                                $ts_list[] = $trow['class_sub_id'];
                              }
                            }
                            mysqli_stmt_close($tsstmt);
                          }
                          foreach ($ts_list as $class_sub_id) {
                            $csstmt = mysqli_prepare($con, "SELECT class_id, subject_id FROM class_subjects WHERE class_sub_id = ?");
                            if ($csstmt) {
                              mysqli_stmt_bind_param($csstmt, 'i', $class_sub_id);
                              mysqli_stmt_execute($csstmt);
                              $csres = mysqli_stmt_get_result($csstmt);
                              if ($csres && mysqli_num_rows($csres) > 0) {
                                $cs = mysqli_fetch_assoc($csres);
                                $c_id = $cs['class_id'];
                                $s_id = $cs['subject_id'];
                                // fetch class name
                                $cname = '';
                                $cstmt2 = mysqli_prepare($con, "SELECT `class` FROM classes WHERE class_id = ?");
                                if ($cstmt2) {
                                  mysqli_stmt_bind_param($cstmt2, 'i', $c_id);
                                  mysqli_stmt_execute($cstmt2);
                                  $cres2 = mysqli_stmt_get_result($cstmt2);
                                  if ($cres2 && mysqli_num_rows($cres2) > 0) {
                                    $crow2 = mysqli_fetch_assoc($cres2);
                                    $cname = $crow2['class'] ?? '';
                                  }
                                  mysqli_stmt_close($cstmt2);
                                }
                                // fetch subject name
                                $sname = '';
                                $sstmt2 = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ?");
                                if ($sstmt2) {
                                  mysqli_stmt_bind_param($sstmt2, 'i', $s_id);
                                  mysqli_stmt_execute($sstmt2);
                                  $sres2 = mysqli_stmt_get_result($sstmt2);
                                  if ($sres2 && mysqli_num_rows($sres2) > 0) {
                                    $srow2 = mysqli_fetch_assoc($sres2);
                                    $sname = $srow2['subject'] ?? '';
                                  }
                                  mysqli_stmt_close($sstmt2);
                                }
                                ?>
                           <option value="<?php echo htmlspecialchars($c_id . ',' . $s_id, ENT_QUOTES); ?>"><?php echo htmlspecialchars($cname . ':' . $sname, ENT_QUOTES); ?></option>
                          <?php }
                              mysqli_stmt_close($csstmt);
                            }
                          }
                          ?>
                                         </select>
                                                                          
                                </div>         
     <div class="form-group">
                                                          <label>Upload  new File (Leave blank if not changing)</label>
                                                          <input type="file" name="image"  id="filer_input">
                                                    </div>
                                   
                                <div class="form-group">                                                                
                                        <button class="btn btn-primary" type="submit">Edit</button>
                                                              </div>
                            </form>
                          </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
 <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
  
</body>

</html>
 