<?php
include '../includes/conn.php';

if (!isset($_SESSION['teachersys'])) {
    header('Location: login.php');
    exit;
}

// Validate GET parameters
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$class = filter_input(INPUT_GET, 'class', FILTER_VALIDATE_INT);
$term = filter_input(INPUT_GET, 'term', FILTER_VALIDATE_INT);
$as = filter_input(INPUT_GET, 'as', FILTER_SANITIZE_STRING);

if (!$id) {
    header('Location: marks');
    exit;
}

// Initialize variables
$comment = '';
$scale = '';

?>

<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>View Marks-School Manager</title>
 <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
 <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
        <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->
     
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                     Edit Comment
                    </header>
                          <div class="panel-body">
                    
 <form method="POST" name='form' class="form" action=""  enctype="multipart/form-data">
                              <?php
                                        if (isset($_POST['comment'], $_POST['scale'])) {
                                          $p_comment = trim($_POST['comment']);
                                          $p_scale = filter_var($_POST['scale'], FILTER_SANITIZE_STRING);
                                          if ((empty($p_comment)) || (empty($p_scale))) {
                                          echo '<div class="alert alert-danger">All Fields required</div>';
                                          } else {
                                            $ust = mysqli_prepare($con, "UPDATE teachercomments SET comment = ?, scale = ? WHERE teachercomment_id = ?");
                                            if ($ust) {
                                                mysqli_stmt_bind_param($ust, 'ssi', $p_comment, $p_scale, $id);
                                                mysqli_stmt_execute($ust);
                                                mysqli_stmt_close($ust);
                                            }
                                            echo '<div class="alert alert-success">Comment Successfully Edited. Click <a href="marks?as=' . htmlspecialchars($as, ENT_QUOTES) . '&amp;term=' . htmlspecialchars($term, ENT_QUOTES) . '&amp;class=' . htmlspecialchars($class, ENT_QUOTES) . '">here</a> to go back</div>';
                                        }
                                        }
                                            // fetch existing comment
                                            $tstmt = mysqli_prepare($con, "SELECT teachercomment_id, comment, scale FROM teachercomments WHERE teachercomment_id = ?");
                                            if ($tstmt) {
                                                mysqli_stmt_bind_param($tstmt, 'i', $id);
                                                mysqli_stmt_execute($tstmt);
                                                $tres = mysqli_stmt_get_result($tstmt);
                                                if ($tres && mysqli_num_rows($tres) > 0) {
                                                    $roww = mysqli_fetch_assoc($tres);
                                                    $comment = $roww['comment'] ?? '';
                                                    $teachercomment_id = $roww['teachercomment_id'] ?? $id;
                                                    $scale = $roww['scale'] ?? '';
                                                }
                                                mysqli_stmt_close($tstmt);
                                            }
                                      ?>
                              
                                 <div class="form-group"><label class=" control-label">Comment(s)</label>
                                 
                                     <input type="text" name="comment" class="form-control" placeholder="Add Comment" value="<?php echo htmlspecialchars($comment, ENT_QUOTES); ?>">
                                                                                       
                                </div>
                       <div class="form-group">
                               <label class=" control-label">Development Scale</label>
                                    <select name="scale" class="form-control">
                                        <option value="<?php echo htmlspecialchars($scale, ENT_QUOTES); ?>"><?php echo htmlspecialchars($scale, ENT_QUOTES); ?></option>
                                            <option value="1">1</option>
                                            <option value="2">2</option>
                                            <option value="3">3</option>
                                            <option value="4">4</option>
                                            
                                        </select>
                                 
                                </div>                                                
                                <div class="form-group">                                                                   
                                        <button class="btn btn-primary" type="submit">Edit</button>
                                                              </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>


    </div>

    <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
  
</body>

</html>
 