<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
    header('Location: login.php');
    exit;
}

// Validate GET parameters
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$cl = filter_input(INPUT_GET, 'cl', FILTER_VALIDATE_INT);
$st = filter_input(INPUT_GET, 'st', FILTER_VALIDATE_INT);
$day = filter_input(INPUT_GET, 'day', FILTER_SANITIZE_STRING);

if (!$id || !$cl || !$st || !$day) {
    header('Location: edittimetable');
    exit;
}

$stream = '';
$class = '';
$fullday = '';

// Fetch class name
$stmt = mysqli_prepare($con, "SELECT `class` FROM classes WHERE class_id = ?");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $cl);
    mysqli_stmt_execute($stmt);
    $cres = mysqli_stmt_get_result($stmt);
    if ($cres && mysqli_num_rows($cres) > 0) {
        $crow = mysqli_fetch_assoc($cres);
        $class = $crow['class'] ?? '';
    }
    mysqli_stmt_close($stmt);
}

// Fetch stream
$stmt = mysqli_prepare($con, "SELECT `stream` FROM streams WHERE stream_id = ?");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $st);
    mysqli_stmt_execute($stmt);
    $sres = mysqli_stmt_get_result($stmt);
    if ($sres && mysqli_num_rows($sres) > 0) {
        $srow = mysqli_fetch_assoc($sres);
        $stream = $srow['stream'] ?? '';
    }
    mysqli_stmt_close($stmt);
}

// Fetch full day name
$stmt = mysqli_prepare($con, "SELECT `day` FROM days WHERE `short` = ?");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 's', $day);
    mysqli_stmt_execute($stmt);
    $dres = mysqli_stmt_get_result($stmt);
    if ($dres && mysqli_num_rows($dres) > 0) {
        $drow = mysqli_fetch_assoc($dres);
        $fullday = $drow['day'] ?? '';
    }
    mysqli_stmt_close($stmt);
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="t">
    <link rel="shortcut icon" href="#" type="image/png">

    <title>Edit Timetable Activity for <?php echo $fullday . ' ' . $class . ' ' . $stream; ?></title>

    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/ckeditor/ckeditor.js"></script>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/ckeditor/samples/sample.css">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
    <link href="<?php echo BASE_URL; ?>/css/chosen/chosen.css" rel="stylesheet">
    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
    <section>
    <?php include 'nav.php'; ?>
        <section class="wrapper">
            <!-- page start-->

            <div class="row">
                <div class="col-lg-8">
                    <section class="panel">
                        <header class="panel-heading">
                            Edit Timetable Activity
                        </header>
                        <div class="panel-body">
                            <?php
                            if (isset($_POST['submit'])) {
                                $classsubject = isset($_POST['classsubject']) ? trim($_POST['classsubject']) : '';
                                $starttime =  trim($_POST['starttime'] ?? '');
                                $activity =  trim($_POST['activity'] ?? '');
                                $endtime =  trim($_POST['endtime'] ?? '');
                                if ((empty($starttime)) || (empty($endtime))) {
                                    $errors[] = 'Some Fields are Empty';
                                }

                                if ((empty($classsubject)) && (empty($activity))) {
                                    $errors[] = 'Class Subject or Activity should be Filled';
                                }
                                if (!empty($errors)) {
                                    foreach ($errors as $error) {
                                        echo '<div class="alert alert-danger">' . $error . '</div>';
                                    }
                                } else {
                                    $status = 1;
                                    // Use prepared statement for update
                                    if (empty($activity)) {
                                        $ustmt = mysqli_prepare($con, "UPDATE timetables SET activity = ?, starttime = ?, endtime = ? WHERE timetable_id = ?");
                                        if ($ustmt) {
                                            mysqli_stmt_bind_param($ustmt, 'sssi', $classsubject, $starttime, $endtime, $id);
                                            mysqli_stmt_execute($ustmt);
                                            mysqli_stmt_close($ustmt);
                                        }
                                    } else {
                                        $ustmt = mysqli_prepare($con, "UPDATE timetables SET activity = ?, starttime = ?, endtime = ? WHERE timetable_id = ?");
                                        if ($ustmt) {
                                            mysqli_stmt_bind_param($ustmt, 'sssi', $activity, $starttime, $endtime, $id);
                                            mysqli_stmt_execute($ustmt);
                                            mysqli_stmt_close($ustmt);
                                        }
                                    }
                                }
                                echo '<div class="alert alert-success">Timetable Activity Successfully Edited. Click <a href="edittimetable?cl=' . htmlspecialchars($cl, ENT_QUOTES) . '&amp;st=' . htmlspecialchars($st, ENT_QUOTES) . '&amp;day=' . htmlspecialchars($day, ENT_QUOTES) . '">here</a> to go back</div>';
                            }
                            // Fetch timetable row
                            $activity = '';
                            $timetable_id = null;
                            $starttime1 = '';
                            $endtime1 = '';
                            $class_subjects = [];

                            $gstmt = mysqli_prepare($con, "SELECT * FROM timetables WHERE timetable_id = ?");
                            if ($gstmt) {
                                mysqli_stmt_bind_param($gstmt, 'i', $id);
                                mysqli_stmt_execute($gstmt);
                                $gres = mysqli_stmt_get_result($gstmt);
                                if ($gres && mysqli_num_rows($gres) > 0) {
                                    $grow = mysqli_fetch_assoc($gres);
                                    $activity = $grow['activity'];
                                    $timetable_id = $grow['timetable_id'];
                                    $starttime1 = $grow['starttime'];
                                    $endtime1 = $grow['endtime'];
                                }
                                mysqli_stmt_close($gstmt);
                            }

                            // If activity is a class_sub_id, fetch related subject/class
                            $class_sub_id = null;
                            $subject = '';
                            if (is_numeric($activity)) {
                                $csid = (int)$activity;
                                $csstmt = mysqli_prepare($con, "SELECT class_sub_id, subject_id, class_id FROM class_subjects WHERE class_sub_id = ?");
                                if ($csstmt) {
                                    mysqli_stmt_bind_param($csstmt, 'i', $csid);
                                    mysqli_stmt_execute($csstmt);
                                    $csres = mysqli_stmt_get_result($csstmt);
                                    if ($csres && mysqli_num_rows($csres) > 0) {
                                        $csrow = mysqli_fetch_assoc($csres);
                                        $subject_id = $csrow['subject_id'];
                                        $class_sub_id = $csrow['class_sub_id'];
                                        $class_id = $csrow['class_id'];

                                        // get class name
                                        $cstmt = mysqli_prepare($con, "SELECT `class` FROM classes WHERE class_id = ?");
                                        if ($cstmt) {
                                            mysqli_stmt_bind_param($cstmt, 'i', $class_id);
                                            mysqli_stmt_execute($cstmt);
                                            $cres = mysqli_stmt_get_result($cstmt);
                                            if ($cres && mysqli_num_rows($cres) > 0) {
                                                $crow = mysqli_fetch_assoc($cres);
                                                $class = $crow['class'] ?? $class;
                                            }
                                            mysqli_stmt_close($cstmt);
                                        }

                                        // get subject name
                                        $sstmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ?");
                                        if ($sstmt) {
                                            mysqli_stmt_bind_param($sstmt, 'i', $subject_id);
                                            mysqli_stmt_execute($sstmt);
                                            $sres = mysqli_stmt_get_result($sstmt);
                                            if ($sres && mysqli_num_rows($sres) > 0) {
                                                $srow = mysqli_fetch_assoc($sres);
                                                $subject = $srow['subject'] ?? '';
                                            }
                                            mysqli_stmt_close($sstmt);
                                        }
                                    }
                                    mysqli_stmt_close($csstmt);
                                }
                            }

                            // Fetch class_subjects for dropdown
                            $dropdown = [];
                            $dstmt = mysqli_prepare($con, "SELECT class_sub_id, class_id, subject_id FROM class_subjects WHERE class_id = ?");
                            if ($dstmt) {
                                mysqli_stmt_bind_param($dstmt, 'i', $cl);
                                mysqli_stmt_execute($dstmt);
                                $dres = mysqli_stmt_get_result($dstmt);
                                if ($dres) {
                                    while ($drow = mysqli_fetch_assoc($dres)) {
                                        $dropdown[] = $drow;
                                    }
                                }
                                mysqli_stmt_close($dstmt);
                            }

                            ?>
                            <form method="post" name='form' class="form" action="" enctype="multipart/form-data">
                                <div class="alert alert-info">Either select a <strong>subject</strong> or Enter <strong>activity</strong> for a particular time session but not both</div>
                                <div class="pharmacy-sec">
                                    <div class="row">
                                        <div class="form-group col-lg-6"><label class="control-label">Subject</label>
                                            <select data-placeholder="Choose class..." name="classsubject" class="chosen-select" style="width:100%;" tabindex="2">
                                                <?php if (!empty($class_sub_id)) { ?>
                                                    <option value="<?php echo htmlspecialchars($class_sub_id, ENT_QUOTES); ?>" selected="selected"><?php echo htmlspecialchars($class . ':' . $subject, ENT_QUOTES); ?></option>
                                                    <option value="">Activity instead</option>
                                                <?php } else { ?>
                                                    <option value="">Select Subject</option>
                                                <?php }
                                                foreach ($dropdown as $drow) {
                                                    $dclass_sub_id = $drow['class_sub_id'];
                                                    // fetch subject and class name for display (already available elsewhere but do a small lookup)
                                                    $dclass = '';
                                                    $dsubject = '';
                                                    // class name
                                                    $cstmt = mysqli_prepare($con, "SELECT `class` FROM classes WHERE class_id = ?");
                                                    if ($cstmt) {
                                                        mysqli_stmt_bind_param($cstmt, 'i', $drow['class_id']);
                                                        mysqli_stmt_execute($cstmt);
                                                        $cres = mysqli_stmt_get_result($cstmt);
                                                        if ($cres && mysqli_num_rows($cres) > 0) {
                                                            $crow = mysqli_fetch_assoc($cres);
                                                            $dclass = $crow['class'] ?? '';
                                                        }
                                                        mysqli_stmt_close($cstmt);
                                                    }
                                                    // subject name
                                                    $sstmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ?");
                                                    if ($sstmt) {
                                                        mysqli_stmt_bind_param($sstmt, 'i', $drow['subject_id']);
                                                        mysqli_stmt_execute($sstmt);
                                                        $sres = mysqli_stmt_get_result($sstmt);
                                                        if ($sres && mysqli_num_rows($sres) > 0) {
                                                            $srow = mysqli_fetch_assoc($sres);
                                                            $dsubject = $srow['subject'] ?? '';
                                                        }
                                                        mysqli_stmt_close($sstmt);
                                                    }
                                                ?>
                                                    <option value="<?php echo htmlspecialchars($dclass_sub_id, ENT_QUOTES); ?>"><?php echo htmlspecialchars($dclass . ':' . $dsubject, ENT_QUOTES); ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-6"><label class="control-label">Activity (Enter if isn't a subject e.g Lunch)</label>
                                            <?php
                                            if (is_numeric($activity) == FALSE) {
                                            ?>
                                                <input type="text" class="form-control" name="activity" placeholder="enter activity" value="<?php echo $activity; ?>">
                                            <?php } else { ?>
                                                <input type="text" class="form-control" name="activity" placeholder="enter activity">
                                            <?php } ?>
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label class="control-label">Start Time</label>
                                            <div class="input-group bootstrap-timepicker">
                                                <span class="input-group-btn">
                                                    <button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button>
                                                </span>
                                                <input type="text" class="form-control" name="starttime" required="required" value="<?php echo $starttime1; ?>">

                                            </div>
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label class="control-label">End Time</label>
                                            <div class="input-group bootstrap-timepicker">
                                                <input type="text" class="form-control" name="endtime" required="required" value="<?php echo $endtime1; ?>">
                                                <span class="input-group-btn">
                                                    <button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <button class="btn btn-primary" type="submit" name="submit">Submit</button>
                                </div>
                            </form>
                        </div>

                </div>
        </section>

        </div>

        </div>


        </div>
        <!-- page end-->
    </section>


    </div>
    <!-- main content end-->
    </section>

    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/chosen/chosen.jquery.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/pickers-init.js?<?php echo time(); ?>"></script>
    <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
    <script>
        $('.timepicker-24').timepicker({
            autoclose: true,
            minuteStep: 5,
            showSeconds: false,
            showMeridian: false
        });
        var config = {
            '.chosen-select': {},
            '.chosen-select-deselect': {
                allow_single_deselect: true
            },
            '.chosen-select-no-single': {
                disable_search_threshold: 10
            },
            '.chosen-select-no-results': {
                no_results_text: 'Oops, nothing found!'
            },
            '.chosen-select-width': {
                width: "95%"
            }
        }
        for (var selector in config) {
            $(selector).chosen(config[selector]);
        }
    </script>
</body>

</html>