<?php
include '../includes/conn.php';

// Require authenticated teacher session
if (!isset($_SESSION['teachersys'])) {
    header('Location: login.php');
    exit;
}

// Validate and cast GET id to integer
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
    // Bad or missing id — send back to classes listing
    header('Location: classes.php');
    exit;
}

$classname = 'Class';
$timetable_id = null;
$timetable_ext = '';

// Fetch class name using a prepared statement
$stmt = mysqli_prepare($con, "SELECT `class` FROM classes WHERE class_id = ?");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    if ($res && mysqli_num_rows($res) > 0) {
        $row1 = mysqli_fetch_assoc($res);
        $classname = $row1['class'] ?? $classname;
    }
    mysqli_stmt_close($stmt);
}

// Fetch timetable meta (if any) using a prepared statement
$tstmt = mysqli_prepare($con, "SELECT timetable_id, ext FROM timetables WHERE class_id = ?");
if ($tstmt) {
    mysqli_stmt_bind_param($tstmt, 'i', $id);
    mysqli_stmt_execute($tstmt);
    $tres = mysqli_stmt_get_result($tstmt);
    if ($tres && mysqli_num_rows($tres) > 0) {
        $row11 = mysqli_fetch_assoc($tres);
        $timetable_id = $row11['timetable_id'] ?? null;
        $timetable_ext = $row11['ext'] ?? '';
    }
    mysqli_stmt_close($tstmt);
}
?>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title><?php echo $classname; ?> Timetable | School Manager</title>


    <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">

    <link href="<?php echo BASE_URL; ?>/css/animate.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">


</head>

<body>

    <div id="wrapper">

        
        <?php include 'nav.php'; ?>

        <div id="page-wrapper" class="gray-bg">
        <div class="row border-bottom">
        <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
        <div class="navbar-header">
            <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
         
        </div>
            <ul class="nav navbar-top-links navbar-right">
             
              
                                <li>
                    <a href="logout">
                        <i class="fa fa-sign-out"></i> Log out
                    </a>
                </li>
            </ul>

        </nav>
        </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                
                <div class="col-lg-10">
                    <h2><?php echo $classname; ?> Timetable</h2>
                    <ol class="breadcrumb">
                         <li>              <a href=""><i class="fa fa-home"></i> Home</a>                    </li>
                       
                         <li>
                            <a>Timetable</a>
                        </li>
                        <li class="active">
                            <strong>View Timetable</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>
        <div class="wrapper wrapper-content animated fadeInRight">
            <div class="row">
             
                <div class="col-lg-12">
                          <div class="ibox float-e-margins">
                        <div class="ibox-title">
                            <h5>Class Timetable<small>  All  fields marked (*) shouldn't be left blank</small></h5>
                           
                        </div>
                        <div class="ibox-content">
                   <?php 
                   if(mysqli_num_rows($timetable)>0){
                       ?>
                            <img src="<?php echo BASE_URL; ?>/img/timetables/<?php echo md5($timetable_id).'.'.$timetable_ext.'?'.  time(); ?>" class="img img-responsive">
              <?php     }else{
                       echo '<div class="alert alert-danger">Timetable not uploaded yet</div>';
                   }
                   ?>
                                </div>
                                </div>
        
            </div>
            </div>
         
        </div>
        </div>
       
    </div>
  
    <!-- Mainly scripts -->
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>

    <!-- Page-Level Scripts -->
    <script>
        $(document).ready(function() {
            $('.dataTables-example').dataTable();

            /* Init DataTables */
            var oTable = $('#editable').dataTable();

            /* Apply the jEditable handlers to the table */
            oTable.$('td').editable( 'http://webapplayers.com/example_ajax.php', {
                "callback": function( sValue, y ) {
                    var aPos = oTable.fnGetPosition( this );
                    oTable.fnUpdate( sValue, aPos[0], aPos[1] );
                },
                "submitdata": function ( value, settings ) {
                    return {
                        "row_id": this.parentNode.getAttribute('id'),
                        "column": oTable.fnGetPosition( this )[2]
                    };
                },

                "width": "90%"
            } );


        });
        function fnClickAddRow() {
            $('#editable').dataTable().fnAddData( [
                "Custom row",
                "New row",
                "New row",
                "New row",
                "New row" ] );
        }      
    </script>
    <script>
        var checkboxe = $("#datatable input[type='checkbox']"),
    submitButt= $("#hid");

checkboxe.click(function() {
    submitButt.attr("disabled", !checkboxe.is(":checked"));
});</script>
</body>

</html>