<?php
include '../includes/conn.php';
if(!isset($_SESSION['teachersys'])){
header('Location:login');
exit;
}
$session_teacher = filter_var($_SESSION['teachersys'] ?? 0, FILTER_VALIDATE_INT);
if (!$session_teacher) {
    header('Location:login');
    exit;
}
?>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Change Password | School Manager</title>
   <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">

    <link href="<?php echo BASE_URL; ?>/css/animate.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">

</head>

<body>

    <div id="wrapper">

        <?php include 'nav.php'; ?>

        <div id="page-wrapper" class="gray-bg">
        <div class="row border-bottom">
        <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
        <div class="navbar-header">
            <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
          
        </div>
            <ul class="nav navbar-top-links navbar-right">
               
                <li>
                    <a href="logout">
                        <i class="fa fa-sign-out"></i> Log out
                    </a>
                </li>
            </ul>

        </nav>
        </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2>Set New Password</h2>
                    <ol class="breadcrumb">
                        <li>              <a href=""><i class="fa fa-home"></i> Home</a>                    </li>
                                           <li class="active">
                            <strong>Change Password</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>
        <div class="wrapper wrapper-content">
                                <div class="row">
                <div class="col-lg-6">
                    <div class="ibox float-e-margins">
                        <div class="ibox-title">
                            <h5>Change Password <small>Ensure to fill all neccesary fields</small></h5>
                           
                        </div>
                        <div class="ibox-content">
                                         <?php
                                                             if(isset($_POST['oldpass'],$_POST['newpass'],$_POST['repeat'])){
                               
                                                                     $old = trim((string)($_POST['oldpass'] ?? ''));
                                                                     $new = trim((string)($_POST['newpass'] ?? ''));
                                                                     $repeat = trim((string)($_POST['repeat'] ?? ''));
                                                                    $errors = [];
                                                                    if($old === '' || $new === '' || $repeat === ''){
                                                                             $errors[] = 'Enter all fields to proceed';
                                                                    }

                                                                    // fetch current hash
                                                                    $pass = '';
                                                                    $selStmt = mysqli_prepare($con, "SELECT password FROM teachers WHERE teacher_id = ? LIMIT 1");
                                                                    if ($selStmt) {
                                                                        mysqli_stmt_bind_param($selStmt, 'i', $session_teacher);
                                                                        mysqli_stmt_execute($selStmt);
                                                                        $sres = mysqli_stmt_get_result($selStmt);
                                                                        if ($sres && $srow = mysqli_fetch_assoc($sres)) {
                                                                            $pass = $srow['password'] ?? '';
                                                                        }
                                                                        mysqli_stmt_close($selStmt);
                                                                    }

                                                                    if ($pass === '' || !password_verify($old, $pass)){
                                                                             $errors[] = 'Enter correct old password';
                                                                    }
                                                                                 if($new !== $repeat){
                                                                             $errors[] = 'The new password does not match with the repeat';
                                                                                                                                                }
                                                                if(!empty($errors)){
foreach($errors as $error){ 
 ?>
 <div class="alert alert-danger"><?php echo htmlspecialchars($error, ENT_QUOTES); ?></div>
<?php 
}         }   else{
                                       
                                                                                    $hash = password_hash($new, PASSWORD_DEFAULT);
                                                                                    $updStmt = mysqli_prepare($con, "UPDATE teachers SET password = ? WHERE teacher_id = ?");
                                                                                    if ($updStmt) {
                                                                                        mysqli_stmt_bind_param($updStmt, 'si', $hash, $session_teacher);
                                                                                        $ok = mysqli_stmt_execute($updStmt);
                                                                                        if ($ok) {
                                                                                            echo '<div class="alert alert-success">Password successfully changed. Click <a href="logout">Here</a> to login again</div>';
                                                                                        } else {
                                                                                            echo '<div class="alert alert-danger">' . htmlspecialchars('Database error: ' . mysqli_stmt_error($updStmt), ENT_QUOTES) . '</div>';
                                                                                        }
                                                                                        mysqli_stmt_close($updStmt);
                                                                                    } else {
                                                                                        echo '<div class="alert alert-danger">' . htmlspecialchars('Database error: could not prepare statement', ENT_QUOTES) . '</div>';
                                                                                    }
                                                                     }
                                                             }
                                                                ?>
                          
                            <form method="post" name='form' class="form" action=""  enctype="multipart/form-data">
                                <div class="form-group"> <label class="control-label">Enter Old Password</label>

                              <input type="password" name="oldpass" class="form-control" placeholder="Enter  Old Password"  required="required"></div>
                                                                                                             
                                                        <div class="form-group"> <label class="control-label">Enter new Password</label>

                              <input type="password" name="newpass" class="form-control" placeholder="Enter  new Password"  required="required"></div>
                                         <div class="form-group"> <label class="control-label">Repeat New Password</label>

                              <input type="password" name="repeat" class="form-control" placeholder="Repeat new Password"  required="required"></div>
                                                                                                  
                                <div class="form-group">
                                        <button class="btn btn-primary" type="submit">Change Password</button>
                                                            </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>


    </div>

    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>
        <script>
            $(document).ready(function () {
                $('.i-checks').iCheck({
                    checkboxClass: 'icheckbox_square-green',
                    radioClass: 'iradio_square-green',
                });
            });
        </script>
</body>

</html>