<?php
include '../includes/conn.php';
 if(!isset($_SESSION['teachersys'])) {
header('Location:login.php');
     exit;
    }
    $session_teacher = filter_var($_SESSION['teachersys'] ?? 0, FILTER_VALIDATE_INT);
    if (!$session_teacher) {
        header('Location:login.php');
        exit;
    }
   ?>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Students Diary | School Manager</title>

    <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- Data Tables -->
    <link href="<?php echo BASE_URL; ?>/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">

    <link href="<?php echo BASE_URL; ?>/css/animate.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">

</head>

<body>

    <div id="wrapper">

        
        <?php include 'nav.php'; ?>

        <div id="page-wrapper" class="gray-bg">
        <div class="row border-bottom">
        <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
        <div class="navbar-header">
            <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
         
        </div>
            <ul class="nav navbar-top-links navbar-right">
             
              
                                <li>
                    <a href="logout">
                        <i class="fa fa-sign-out"></i> Log out
                    </a>
                </li>
            </ul>

        </nav>
        </div>
            <div class="row wrapper border-bottom white-bg page-heading">                
                <div class="col-lg-10">
                    <h2>Students Diary</h2>
                    <ol class="breadcrumb">
                         <li> <a href=""><i class="fa fa-home"></i> Home</a></li>
                                  
                        <li class="active">
                            <strong>View Assignments</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>
        <div class="wrapper wrapper-content animated fadeInRight">
            <div class="row">
               
                <div class="col-lg-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>All Assignments <small>Sort, search</small></h5>
                                  </div>
                    <div class="ibox-content">
                        <?php
                                                $stmt = mysqli_prepare($con, "SELECT * FROM assignments WHERE status=1 AND teacher_id = ? ORDER BY timestamp DESC");
                                                mysqli_stmt_bind_param($stmt, 'i', $session_teacher);
                                                mysqli_stmt_execute($stmt);
                                                $getassignments = mysqli_stmt_get_result($stmt);
                                             if($getassignments && mysqli_num_rows($getassignments) > 0) { 
 ?>
                    <table class="table table-striped table-bordered table-hover dataTables-example" >
                   <thead>
                                        <tr>
                                              <th>Date</th>
                                            <th>Subject</th>
                                            <th>Class</th>
                                                 <th>Assignment</th>
                                                           <th>Action</th>
                                        </tr>
                                    </thead>
                    <tbody>
              <?php    
                                                                            while ($row = mysqli_fetch_assoc($getassignments)) {
                                                                                    $assignment_id = (int)($row['assignment_id'] ?? 0);
                                                                                     $class_id = (int)($row['class_id'] ?? 0);
                                                                                    $subject_id = (int)($row['subject_id'] ?? 0);
                                                                                    $assignment = strip_tags($row['assignment'] ?? '');
                                                                                        $timestamp = (int)($row['timestamp'] ?? 0);
                                                                                         // lookup class
                                                                                         $class = '';
                                                                                         if ($class_id) {
                                                                                             $classStmt = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id = ? LIMIT 1");
                                                                                             if ($classStmt) {
                                                                                                 mysqli_stmt_bind_param($classStmt, 'i', $class_id);
                                                                                                 mysqli_stmt_execute($classStmt);
                                                                                                 $cr = mysqli_stmt_get_result($classStmt);
                                                                                                 if ($cr && $r2 = mysqli_fetch_assoc($cr)) $class = $r2['class'] ?? '';
                                                                                                 mysqli_stmt_close($classStmt);
                                                                                             }
                                                                                         }
                                                                                         // lookup subject
                                                                                         $subject = '';
                                                                                         if ($subject_id) {
                                                                                             $subStmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1");
                                                                                             if ($subStmt) {
                                                                                                 mysqli_stmt_bind_param($subStmt, 'i', $subject_id);
                                                                                                 mysqli_stmt_execute($subStmt);
                                                                                                 $sr = mysqli_stmt_get_result($subStmt);
                                                                                                 if ($sr && $r3 = mysqli_fetch_assoc($sr)) $subject = $r3['subject'] ?? '';
                                                                                                 mysqli_stmt_close($subStmt);
                                                                                             }
                                                                                         }
                                          										
                                                                                       ?>
               
                     <tr class="gradeA">
                                   <td>
                                   <?php echo htmlspecialchars(date('d/M/Y', (int)$timestamp), ENT_QUOTES);?>
                               </td>
                        <td><?php echo htmlspecialchars($subject, ENT_QUOTES); ?></td>
                        <td><?php echo htmlspecialchars($class, ENT_QUOTES); ?></td>
                        <td><?php echo htmlspecialchars(mb_substr($assignment,0,100) . '...', ENT_QUOTES); ?></td>                                                                                  
											
                                  <td><a href="assignment?id=<?php echo $assignment_id; ?>" class="btn btn-success btn-xs">Details</a>
                           <a href="editassignment?id=<?php echo $assignment_id; ?>" class="btn btn-primary btn-xs"><i class="fa fa-edit"></i> Edit</a>
                               <a href="removeassignment?id=<?php echo $assignment_id; ?>" class="btn btn-danger btn-xs" onclick="return confirm_delete<?php echo $assignment_id;?>()"><i class="fa fa-times"></i> Remove</a>
                                                          <script type="text/javascript">
function confirm_delete<?php echo $assignment_id; ?>() {
  return confirm('You are about To Remove this Item.Are you sure you want to proceed?');
}
</script>              
                                                                                        </td>
                                        </tr>
                 <?php }?>
                    </tbody>
                                    </table>
 <?php }?>
                    </div>
                </div>
            </div>
            </div>
          
        </div>
        </div>


    </div>

    <!-- Mainly scripts -->
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>

    <script src="<?php echo BASE_URL; ?>/js/plugins/jeditable/jquery.jeditable.js"></script>

    <!-- Data Tables -->
    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/dataTables.bootstrap.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>

    <!-- Page-Level Scripts -->
    <script>
        $(document).ready(function() {
            $('.dataTables-example').dataTable();

            /* Init DataTables */
            var oTable = $('#editable').dataTable();

            /* Apply the jEditable handlers to the table */
            oTable.$('td').editable( 'http://webapplayers.com/example_ajax.php', {
                "callback": function( sValue, y ) {
                    var aPos = oTable.fnGetPosition( this );
                    oTable.fnUpdate( sValue, aPos[0], aPos[1] );
                },
                "submitdata": function ( value, settings ) {
                    return {
                        "row_id": this.parentNode.getAttribute('id'),
                        "column": oTable.fnGetPosition( this )[2]
                    };
                },

                "width": "90%"
            } );


        });

        function fnClickAddRow() {
            $('#editable').dataTable().fnAddData( [
                "Custom row",
                "New row",
                "New row",
                "New row",
                "New row" ] );

        }
    </script>
</body>


<!-- Mirrored from webapplayers.com/inspinia_admin-v1.2/table_data_tables.html by HTTrack Website Copier/3.x [XR&CO'2013], Sun, 15 Jun 2014 11:38:48 GMT -->
</html>