<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

$cl = isset($_GET['cl']) ? (int)$_GET['cl'] : 0;
$as = isset($_GET['as']) ? (int)$_GET['as'] : 0;
$sub = isset($_GET['sub']) ? (int)$_GET['sub'] : 0;
$tm = isset($_GET['tm']) ? (int)$_GET['tm'] : 0;
$dt_raw = isset($_GET['dt']) ? $_GET['dt'] : '';
if ($cl <= 0 || $as <= 0 || $sub <= 0 || $tm <= 0) {
  echo '<div class="alert alert-danger">Invalid parameters</div>';
  exit;
}

// Normalize date for display and for DB (store as string)
$dt_display = '';
if (is_numeric($dt_raw) && ((int)$dt_raw) > 0) {
  $dt_display = date('d/M/Y', (int)$dt_raw);
  $dt_db = (string)((int)$dt_raw);
} else {
  $ts = strtotime((string)$dt_raw);
  if ($ts !== false) {
    $dt_display = date('d/M/Y', $ts);
    $dt_db = date('Y-m-d', $ts);
  } else {
    $dt_display = htmlspecialchars((string)$dt_raw);
    $dt_db = htmlspecialchars((string)$dt_raw);
  }
}
?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Add Marks-School Manager</title>
   <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
 <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
        <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->
     
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                     Add assesment Results
                    </header>
                          <div class="panel-body">  
                        
                                <?php
                                $getclasses = mysqli_query($con, "SELECT class,category_id FROM classes WHERE class_id=" . $cl . " LIMIT 1");
                                       $class2 = '';
                                       $category_id2 = 0;
                                       if ($getclasses) {
                                           $row2 = mysqli_fetch_assoc($getclasses);
                                           $class2 = $row2['class'] ?? '';
                                           $category_id2 = (int)($row2['category_id'] ?? 0);
                                       }
                                        $getsubjects = mysqli_query($con, "SELECT subject FROM subjects WHERE subject_id=" . $sub . " LIMIT 1");
                                       $subject2 = '';
                                       if ($getsubjects) {
                                           $row3 = mysqli_fetch_assoc($getsubjects);
                                           $subject2 = $row3['subject'] ?? '';
                                       }
                                       $getterm = mysqli_query($con, "SELECT term,year FROM financialterms WHERE financialterm_id=" . $tm . " LIMIT 1");
  $term2 = '';
  $year = '';
  if ($getterm) {
    $row4 = mysqli_fetch_assoc($getterm);
    $term2 = $row4['term'] ?? '';
    $year = $row4['year'] ?? '';
  }
  $gettypes = mysqli_query($con, "SELECT assessmenttype FROM assessmenttypes WHERE assessmenttype_id=" . $as . " LIMIT 1");
  $assessment = '';
  if ($gettypes) {
    $rowt = mysqli_fetch_assoc($gettypes);
    $assessment = $rowt['assessmenttype'] ?? '';
  }
                                ?>
                                    <table  class="display table  table-striped" id="dynamic-table">
     
        <tbody>
         
                <tr class="gradeA">
                       <th>Assessment</th>
                       <td><?php echo $assessment;?></td>
                  </tr>
                 <tr class="gradeA">
                       <th>Class</th>
                       <td><?php echo $class2;?></td>
                  </tr>
                       <tr class="gradeA">
                             <th>Subject</th>
            <td><?php echo $subject2; ?></td>
            </tr>
                           <tr class="gradeA">
                             <th> Term</th>
                             <td><?php echo $term2.' '.$year;?></td>
            </tr>
                <tr class="gradeA">
                                 <th> Date</th>
                                 <td><?php echo htmlspecialchars($dt_display); ?></td>
                </tr>
                   </tbody>
                        </table>
                              
                        </div>
                      </section>
                        </div>
                <div class="col-lg-8">
                   <section class="panel">
                    <header class="panel-heading">
                     Add Assessment Results
                    </header>
                          <div class="panel-body">  
  <?php
  // check if marks already exist for the same assessment/date
  $check_stmt = mysqli_prepare($con, "SELECT 1 FROM marks WHERE assessment=? AND term_id=? AND subject_id=? AND class_id=? AND date=? LIMIT 1");
  if ($check_stmt) {
    mysqli_stmt_bind_param($check_stmt, 'iiiis', $as, $tm, $sub, $cl, $dt_db);
    mysqli_stmt_execute($check_stmt);
    mysqli_stmt_store_result($check_stmt);
    if (mysqli_stmt_num_rows($check_stmt) > 0) {
      echo '<div class="alert alert-danger">Marks Already Added for that day</div>';
      mysqli_stmt_close($check_stmt);
    } else {
      mysqli_stmt_close($check_stmt);
      // get students
      $getstudents = mysqli_query($con, "SELECT student_id,fullname FROM students WHERE class_id=" . $cl);
      if ($getstudents) {
        // prepare statements for inserts
        $ins_marks = mysqli_prepare($con, "INSERT INTO marks(marks,subject_id,class_id,assessment,student_id,term_id,date,status) VALUES(0,?,?,?,?,?,? ,1)");
        $ins_comment = mysqli_prepare($con, "INSERT INTO teachercomments(mark_id,scale,comment,status) VALUES(?,?,?,1)");

        while ($row = mysqli_fetch_assoc($getstudents)) {
          $student_id = (int)($row['student_id'] ?? 0);
          $fullname = $row['fullname'] ?? '';
          ?>
          <form method="POST" name='form' class="form" action="" enctype="multipart/form-data">
          <?php
          // process submission for this student if present
          if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['scale' . $student_id])) {
            $scales = $_POST['scale' . $student_id] ?? [];
            $comments = $_POST['comment' . $student_id] ?? [];
            // insert marks
            if ($ins_marks) {
              mysqli_stmt_bind_param($ins_marks, 'iiiiis', $sub, $cl, $as, $student_id, $tm, $dt_db);
              mysqli_stmt_execute($ins_marks);
              $mark_id = (int) mysqli_insert_id($con);
            } else {
              $mark_id = 0;
            }

            // insert comments (skip empty)
            if ($ins_comment && $mark_id > 0 && is_array($comments)) {
              for ($i = 0; $i < count($comments); $i++) {
                $comment_text = trim((string)($comments[$i] ?? ''));
                $scale_val = isset($scales[$i]) ? (int)$scales[$i] : 0;
                if ($comment_text === '') continue;
                mysqli_stmt_bind_param($ins_comment, 'iis', $mark_id, $scale_val, $comment_text);
                mysqli_stmt_execute($ins_comment);
              }
            }

            if ($mark_id > 0) {
              echo '<div class="alert alert-success"><strong>' . htmlspecialchars($fullname) . '</strong> Marks Successfully Added. Click <a href="viewmarks">here</a> to view marks</div>';
            }
          }
          ?>
          <div class="row">
            <div class="col-lg-12">
              <strong style="color:#000;text-transform: uppercase;margin-bottom: 10px;float: left"><?php echo htmlspecialchars($fullname); ?></strong>
            </div>
          </div>
          <div class="pharmacy-sec<?php echo $student_id; ?>">
            <div class="row">
              <div class="form-group col-lg-8"><label class=" control-label">Comment(s)</label>
                <input type="text" name="comment<?php echo $student_id;?>[]" class="form-control" placeholder="Add Comment">
              </div>
              <div class="form-group col-lg-3">
                <label class=" control-label">Development Scale</label>
                <select name="scale<?php echo $student_id;?>[]" class="form-control">
                  <option value="1">1</option>
                  <option value="2">2</option>
                  <option value="3">3</option>
                  <option value="4">4</option>
                </select>
              </div>
            </div>
          </div>
          <div class="form-group">
            <button class="drug_button<?php echo $student_id; ?> btn btn-info btn-xs">Add more</button>
          </div>
          <script>
          $('.drug_button<?php echo $student_id;?>').click(function(e){ //on add input button click
            e.preventDefault();
            $(document).ready(function(){
              $('.pharmacy-sec<?php echo $student_id;?>').append('<div class="row"> <div class="form-group col-lg-8"><input type="text" name="comment<?php echo $student_id;?>[]" class="form-control" placeholder="Add Comment"> </div>  <div class="form-group col-lg-3"><select name="scale<?php echo $student_id;?>[]" class="form-control"><option value="1">1</option><option value="2">2</option> <option value="3">3</option>  <option value="4">4</option> </select></div><button class="remove_drug<?php echo $student_id;?>  btn btn-danger btn-xs"><i class="fa fa-minus"></i></button>');
            });
            $('.pharmacy-sec<?php echo $student_id;?>').on("click",".remove_drug<?php echo $student_id; ?>", function(e){ //user click on remove text
              e.preventDefault(); $(this).parent('div').remove(); x--;
            });
          });
          </script>
          <?php
        }

        // close prepared statements
        if ($ins_marks) mysqli_stmt_close($ins_marks);
        if ($ins_comment) mysqli_stmt_close($ins_comment);
      }
    }
  } else {
    echo '<div class="alert alert-danger">Unable to check existing marks.</div>';
  }
  ?>
                         </div>
                   </section>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
        <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>

  
</body>

</html>
 