<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys']) || (($_SESSION['classteacher'] ?? '') !== 'yes')) {
  header('Location: login.php');
  exit;
}

$class_id = isset($_SESSION['class_id']) ? (int)$_SESSION['class_id'] : 0;
if ($class_id <= 0) {
  header('Location: login.php');
  exit;
}

$getclass = mysqli_query($con, "SELECT class FROM classes WHERE class_id=" . $class_id . " LIMIT 1");
$class = '';
if ($getclass) {
  $row2 = mysqli_fetch_assoc($getclass);
  $class = $row2['class'] ?? '';
}
              ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Add <?php echo $class;?> Attendance</title>
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
 <link href="<?php echo BASE_URL;?>/datapicker/datepicker3.css" rel="stylesheet">
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-10">
                      <section class="panel">
                    <header class="panel-heading">
                      Add <?php echo $class;?>  Attendance
                    </header>
                          <div class="panel-body">
                              <?php
                              if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['date'], $_POST['time'])) {
                                  $date_input = trim((string)($_POST['date'] ?? ''));
                                  $date_ts = strtotime($date_input);
                                  $date_val = $date_ts ? date('Y-m-d', $date_ts) : '';
                                  $term = isset($_POST['term']) ? (int)$_POST['term'] : 0;
                                  $time = trim((string)($_POST['time'] ?? ''));
                                  $attendance = $_POST['attendance'] ?? [];
                                  $status = $_POST['status'] ?? [];
                                  $teacher_id = isset($_SESSION['teachersys']) ? (int)$_SESSION['teachersys'] : 0;
                                  if (empty($date_val) || empty($term) || $time === '') {
                                      echo '<div class="alert alert-danger">Some Fields are Empty</div>';
                                  } else {
                                      // insert attendance with prepared statement
                                      $ins = mysqli_prepare($con, "INSERT INTO attendance(date,term_id,teacher_id,class_id,time,status) VALUES(?,?,?,?,?,1)");
                                      if ($ins) {
                                        mysqli_stmt_bind_param($ins, 'siiis', $date_val, $term, $teacher_id, $class_id, $time);
                                        mysqli_stmt_execute($ins);
                                        $last_id = (int) mysqli_insert_id($con);
                                        mysqli_stmt_close($ins);

                                        // insert details
                                        $det = mysqli_prepare($con, "INSERT INTO attendancedetails(attendance_id,student_id,details,status) VALUES(?,?,?,?)");
                                        if ($det) {
                                          for ($i = 0; $i < count($attendance); $i++) {
                                            $student_id = (int)$attendance[$i];
                                            $st = isset($status[$i]) ? (int)$status[$i] : 0;
                                            $details = '';
                                            mysqli_stmt_bind_param($det, 'iisi', $last_id, $student_id, $details, $st);
                                            mysqli_stmt_execute($det);
                                          }
                                          mysqli_stmt_close($det);
                                        }

                                        // ensure every student in class has a details row
                                        $getstudents = mysqli_query($con, "SELECT student_id FROM students WHERE class_id=" . $class_id);
                                        if ($getstudents) {
                                          $checkStmt = mysqli_prepare($con, "SELECT 1 FROM attendancedetails WHERE attendance_id = ? AND student_id = ? LIMIT 1");
                                          $insMissing = mysqli_prepare($con, "INSERT INTO attendancedetails(attendance_id,student_id,details,status) VALUES(?,?,?,?)");
                                          while ($grow = mysqli_fetch_assoc($getstudents)) {
                                            $student_id = (int) ($grow['student_id'] ?? 0);
                                            if ($student_id <= 0) continue;
                                            $found = false;
                                            if ($checkStmt) {
                                              mysqli_stmt_bind_param($checkStmt, 'ii', $last_id, $student_id);
                                              mysqli_stmt_execute($checkStmt);
                                              mysqli_stmt_store_result($checkStmt);
                                              if (mysqli_stmt_num_rows($checkStmt) > 0) {
                                                $found = true;
                                              }
                                            }
                                            if (!$found && $insMissing) {
                                              $details = '';
                                              $zero = 0;
                                              mysqli_stmt_bind_param($insMissing, 'iisi', $last_id, $student_id, $details, $zero);
                                              mysqli_stmt_execute($insMissing);
                                            }
                                          }
                                          if ($checkStmt) mysqli_stmt_close($checkStmt);
                                          if ($insMissing) mysqli_stmt_close($insMissing);
                                        }

                                        echo '<div class="alert alert-success">Attendance Successfully Added.</div>';
                                      }
                                  }
                              }
                              ?>
                                 <form action="" method="post" > 
                                     <div class="row">
                                                             
                                                                        <div class="form-group col-lg-4" id="data_1">
                              <label class="control-label">Date</label>
                                      <div class="input-group date">
                                          <span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" class="form-control" name="date" required="required" placeholder="Date">
                                                 </div>
                            </div>
                                                <div class="form-group col-lg-4">
                                      <label class="control-label">*Term and Year</label>                                
                                        <select name="term" class="form-control">
                                                                                           <?php
 $terms = mysqli_query($con, "SELECT financialterm_id,term,year FROM financialterms WHERE status=1");
  if ($terms) {
    while ($row = mysqli_fetch_assoc($terms)) {
      $financialterm_id = (int) ($row['financialterm_id'] ?? 0);
      $termName = $row['term'] ?? '';
      $year = $row['year'] ?? '';
  ?>
                                            <option value="<?php echo $financialterm_id; ?>"><?php echo htmlspecialchars('Term ' . $termName . ' ' . $year); ?></option>
  <?php }
  }
  ?>
                                        </select>                                                                     
                                </div>
                              <div class="form-group col-lg-4">
                                      <label class="control-label">* Time</label>                                
                                        <select name="time" class="form-control">
                                            <option value="" selected="selected">AM or PM ?</option>        
                                            <option value="AM">AM</option>        
                                            <option value="PM">PM</option>        
                                            </select>
                                </div>
          <table  class="display table  table-striped" id="datatable">
        <thead>
        <tr>
            <th>&nbsp;</th>
            <th>Full Names</th>
             <th>Attendance</th>
            <th>Nationality</th>
            <th>Gender</th>                                                
                                                               
                  </tr>
        </thead>
        <tbody>
    
          <?php 
                        $students = mysqli_query($con, "SELECT regnumber,student_id,fullname,gender,class_id,status,nationality,ext FROM students WHERE status=1 AND class_id=" . $class_id);
                        if ($students) {
                                        while ($row = mysqli_fetch_assoc($students)) {
                                          $regnumber = $row['regnumber'] ?? '';
                                          $student_id = (int) ($row['student_id'] ?? 0);
                                           $fullname = $row['fullname'] ?? '';
                                          $gender = $row['gender'] ?? '';
                                          $class_id = (int) ($row['class_id'] ?? 0);
                                            $status = (int) ($row['status'] ?? 0);
                                            $nationality = $row['nationality'] ?? '';
                                            $ext = $row['ext'] ?? '';                                               
                                                                                                    
                                                                                       ?>
                 <tr class="gradeA">
                         <td><input type="checkbox" class="hidden" id="attend<?php echo $student_id; ?>"  name="attendance[]" value="<?php echo $student_id; ?>"></td>
                                                              
                                            <td><?php echo htmlspecialchars($fullname); ?></td>
                                              <td>
                                                <select name="status[]" class="form-control select_all" data-id="<?php echo $student_id; ?>">
                                                    <option selected="selected" value="">Select status</option>
                                                    <option value="1">Present</option>
                                                    <option value="2"> Late</option>
                                                    <option value="0">Absent</option>
                                                </select>
                                                       </td>
                                            <td>
                                                <?php                                                                                      
                                            echo htmlspecialchars($nationality);
                                            ?></td>
                                                       <td><?php echo htmlspecialchars($gender); ?></td>
                                                                          							
                                                                                 
                
                                        </tr>
            <?php }
                        }
            ?>
        </tbody>
                        </table>
                                               <button type="submit" class="btn btn-danger" id="hid" name="submit" disabled>Submit</button>
                                 </form>
                          </div>
                              </section>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<script src="<?php echo BASE_URL;?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL;?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL;?>/js/data-tables/DT_bootstrap.js"></script>
    <script src="<?php echo BASE_URL;?>/datapicker/bootstrap-datepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL;?>/js/scripts.js"></script>
<script>
//         var checkboxe = $("#datatable input[type='checkbox']"),
    submitButt= $("#hid");
// checkboxe.click(function() {
//     submitButt.attr("disabled", !checkboxe.is(":checked"));
// });
// function to check if all select box options are selected
function allSelected(selector) {
  let allSelected = true;
  selector.each(function() {
    // console.log(this.value)
    if (this.value == '') {
      // set submit button to disabled if any option is not selected
      submitButt.attr("disabled", true);
      allSelected = false;
    }
  });
  // set submit button to enabled if all options are selected
  if (allSelected) {
    submitButt.attr("disabled", false);
  }
}
// function to check/uncheck checkboxes based on selected dropdown option
function check (val,selector) {
    if (val == '1') {
      selector.attr('checked', true);
    } 
    else if (val == '2'){
      selector.attr('checked', true);
    }
    else {
      selector.attr('checked', false);
    }
}

    $(document).ready(function(){
      // add onchange event to dropdown
      $(".select_all").change(function() {
        console.log(this.value)
        const selector = `#attend${$(this).data('id')}`;
        // check/uncheck checkboxes based on dropdown option
        check(this.value, $(selector));
        allSelected($(".select_all"));
      });
    
            $('#data_1 .input-group.date').datepicker({
                todayBtn: "linked",
                keyboardNavigation: false,
                forceParse: false,
                calendarWeeks: true,
                autoclose: true
            });
            });
</script>
</body>
</html>
