<?php
function create_thumb($directory, $image, $destination) {
  $image_file = $image;
  $image = $directory.$image;

  if (file_exists($image)) {

    $source_size = getimagesize($image);

    if ($source_size !== false) {

      $thumb_width = 200;
      $thumb_height = 200;

      switch($source_size['mime']) {
    case 'image/jpeg':
      if (function_exists('imagecreatefromjpeg')) {
        $source = imagecreatefromjpeg($image);
      } else {
        $source = false;
      }
      break;
    case 'image/png':
      if (function_exists('imagecreatefrompng')) {
        $source = imagecreatefrompng($image);
      } elseif (function_exists('imagecreatefromstring')) {
        $data = @file_get_contents($image);
        $source = $data ? @imagecreatefromstring($data) : false;
      } else {
        $source = false;
      }
      break;
    case 'image/gif':
      if (function_exists('imagecreatefromgif')) {
        $source = imagecreatefromgif($image);
      } elseif (function_exists('imagecreatefromstring')) {
        $data = @file_get_contents($image);
        $source = $data ? @imagecreatefromstring($data) : false;
      } else {
        $source = false;
      }
      break;
      }

    if ($source === false) {
      // GD not available or failed to create source image; abort gracefully
      return false;
    }

    $source_aspect = round(($source_size[0] / $source_size[1]), 1);
      $thumb_aspect = round(($thumb_width / $thumb_height), 1);

      if ($source_aspect < $thumb_aspect) {
        $new_size = array($thumb_width, ($thumb_width / $source_size[0]) * $source_size[1]);
        $source_pos = array(0, ($new_size[1] - $thumb_height) / 2);
      } else if ($source_aspect > $thumb_aspect) {
        $new_size = array(($thumb_width / $source_size[1]) * $source_size[0], $thumb_height);
        $source_pos = array(($new_size[0] - $thumb_width) / 2, 0);
      } else {
        $new_size = array($thumb_width, $thumb_height);
        $source_pos = array(0, 0);
      }

      if ($new_size[0] < 1) $new_size[0] = 1;
      if ($new_size[1] < 1) $new_size[1] = 1;

      // create destination image
      $thumb = imagecreatetruecolor($thumb_width, $thumb_height);

      // Preserve transparency for PNG and GIF
      if ($source_size['mime'] === 'image/png') {
          imagealphablending($thumb, false);
          imagesavealpha($thumb, true);
          $transparent = imagecolorallocatealpha($thumb, 0, 0, 0, 127);
          imagefilledrectangle($thumb, 0, 0, $thumb_width, $thumb_height, $transparent);
      } elseif ($source_size['mime'] === 'image/gif') {
          $trnprt_indx = imagecolortransparent($source);
          if ($trnprt_indx >= 0) {
              $trnprt_color = imagecolorsforindex($source, $trnprt_indx);
              $trnprt_indx2 = imagecolorallocate($thumb, $trnprt_color['red'], $trnprt_color['green'], $trnprt_color['blue']);
              imagefill($thumb, 0, 0, $trnprt_indx2);
              imagecolortransparent($thumb, $trnprt_indx2);
          }
      }

      imagecopyresampled($thumb, $source, 0, 0, $source_pos[0], $source_pos[1], $new_size[0], $new_size[1], $source_size[0], $source_size[1]);

      $saved = false;
      switch($source_size['mime']) {
        case 'image/jpeg':
            $saved = imagejpeg($thumb, $destination.$image_file, 85);
            break;
        case 'image/png':
            $saved = imagepng($thumb, $destination.$image_file);
            break;
        case 'image/gif':
            $saved = imagegif($thumb, $destination.$image_file);
            break;
      }

      // free resources
      if (is_resource($source)) imagedestroy($source);
      if (is_resource($thumb)) imagedestroy($thumb);

      return (bool)$saved;


    }

  return false;
}
}
?>