import HeroSection from "@user/HeroSection";
import Availability from "@user/Availability";
import CTA from "@user/CTA";
import Offers from "@user/Offers";
import { usePage, Link, Head } from "@inertiajs/react";
import { formatPriceTriple } from "@/utils/priceFormatter";

export default function Rooms(){
    const { accommodations = [], featuredAccommodations = [] } = usePage().props;
    
    // Generate room items - use accommodations if available, otherwise use 3 placeholders
    const getRoomItems = () => {
        if (accommodations && accommodations.length > 0) {
            return accommodations.map((acc) => ({
                id: acc.id != null ? String(acc.id) : '',
                name: acc.room_name,
                image: acc.primary_photo ? `/storage/${acc.primary_photo}` : 'https://placehold.co/800x571',
                price: formatPriceTriple(acc.price_fbu, acc.price_usd, acc.price_eur) || 'Price on request',
            }));
        }
        
        // Return 3 placeholder items if no accommodations
        return Array.from({ length: 3 }, (_, index) => ({
            id: `placeholder-${index + 1}`,
            name: `Room ${index + 1}`,
            image: 'https://placehold.co/800x571',
            price: 'Price on request',
        }));
    };

    const roomItems = getRoomItems();

    return(
        <>
        <Head title="Accommodations" />
        <HeroSection heading="Rooms" breadcrumbs={["Home", "Rooms"]} />
        <Availability />
        <section className="section">
        <div className="container">
            <div className="row">
            {roomItems.map((room, index) => (
                <div key={room.id} className="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay={index * 100}>
                    <Link href={room.id && String(room.id).startsWith('placeholder') ? '#' : `/accommodations/${room.id}`} className="room">
                    <figure className="img-wrap">
                        <img src={room.image} alt={room.name} className="img-fluid mb-3" />
                    </figure>
                    <div className="p-3 text-center room-info">
                        <h2>{room.name}</h2>
                        <span className="text-uppercase letter-spacing-1">{room.price} / per night</span>
                    </div>
                    </Link>
                </div>
            ))}
            </div>
        </div>
        </section>
        <Offers featuredAccommodations={featuredAccommodations || []} />
        <CTA />
        </>
    );
}