import React from 'react';
import { usePage } from '@inertiajs/react';

function SuccessAlert({ type }) {
  const { flash } = usePage().props;
  const message = flash?.[type]?.message;

  // Only render the alert if the specific flash message exists.
  if (!message) {
    return null;
  }

  return (
    <div className="alert alert-success alert-dismissible fade show" role="alert">
      <span role="img" aria-label="success">✅</span> {message}
      <button type="button" className="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
  );
}

export default SuccessAlert;
