import { usePage } from '@inertiajs/react';

export default function Photo({ gallery = [] }){
    const { siteinfo } = usePage().props;
    
    // Get dynamic description
    const photosDescription = siteinfo?.photos_description || '';
    const getSliderItems = () => {
        if (gallery && gallery.length > 0) {
            return gallery.map((item, index) => ({
                image: `/storage/${item.photo}`,
                caption: item.caption || item.title || 'Image',
                alt: item.title || `Gallery image ${index + 1}`
            }));
        }
        
        return Array.from({ length: 4 }, (_, index) => ({
            image: `https://placehold.co/1123x700`,
            caption: `Placeholder image ${index + 1}`,
            alt: `Placeholder image ${index + 1}`
        }));
    };

    const sliderItems = getSliderItems();

    const openLightbox = (index) => {
        if (typeof window !== 'undefined' && window.$ && window.$.fancybox) {
            const items = sliderItems.map(item => ({
                src: item.image,
                opts: { caption: item.caption }
            }));
            window.$.fancybox.open(items, {}, index);
        }
    };

    return(
        <>
        <section className="section slider-section bg-light">
        <div className="container">
            <div className="row justify-content-center text-center mb-5">
            <div className="col-md-7">
                <h2 className="heading" data-aos="fade-up">Photos</h2>
                {photosDescription && (
                    <p data-aos="fade-up" data-aos-delay="100">{photosDescription}</p>
                )}
            </div>
            </div>
            <div className="row">
            <div className="col-md-12">
                <div className="home-slider major-caousel owl-carousel mb-5" data-aos="fade-up" data-aos-delay="200">
                {sliderItems.map((item, index) => (
                    <div key={index} className="slider-item">
                        <img 
                            src={item.image} 
                            alt={item.alt} 
                            className="img-fluid" 
                            style={{ cursor: 'pointer' }}
                            onClick={() => openLightbox(index)}
                        />
                    </div>
                ))}
                </div>
            </div>
            
            </div>
        </div>
        </section>
        </>
    );
}