import { Link, usePage } from '@inertiajs/react';

export default function CTA(){
    const { siteinfo, sectionimages } = usePage().props;
    
    // Get dynamic background image
    const backgroundImage = sectionimages?.cta_background 
        ? `/storage/${sectionimages.cta_background}` 
        : '/assets/user/images/hero_4.jpg';
    
    // Get dynamic title
    const ctaTitle = siteinfo?.cta_title || 'A Best Place To Stay. Reserve Now!';
    
    return(
        <>
        <section className="section bg-image overlay" style={{backgroundImage: `url('${backgroundImage}')`}}>
            <div className="container" >
            <div className="row align-items-center">
                <div className="col-12 col-md-6 text-center mb-4 mb-md-0 text-md-left" data-aos="fade-up">
                <h2 className="text-white font-weight-bold">{ctaTitle}</h2>
                </div>
                <div className="col-12 col-md-6 text-center text-md-right" data-aos="fade-up" data-aos-delay="200">
                <Link href="/reservation" className="btn btn-outline-white-primary py-3 text-white px-5">Reserve Now</Link>
                </div>
            </div>
            </div>
        </section>
        </>
    );
}