import { toast } from 'react-hot-toast';

export const useFormResponse = (reset) => {
  return {
    onSuccess: (page) => {
      if (page.props.flash.success) {
        if (!page.props.flash.success.check) {
          toast.success(page.props.flash.success.message);
          reset?.();
        } else {
          toast.error(page.props.flash.success.check);
        }
      }
      if (page.props.flash.error) {
        toast.error(page.props.flash.error.check);
      }
    },
    onError: (errors) => {
      const errorMessage = Object.values(errors)[0];
      toast.error(errorMessage);
    }
  };
};