import FormGroup from "@admin/ui/forms/FormGroup";
import Switch from "@admin/ui/forms/Switch";
import FileUploadInput from "@admin/ui/forms/FileUploadInput";
import Modal from "@admin/ui/Modal";
import { useEffect, useState } from "react";
import { useFormResponse } from '@/hooks/useFormResponse';
import { useForm } from "@inertiajs/react";

export default function EditTestimonial({ isOpen, onClose, initialData }){
    const {data, setData, put, processing, errors} = useForm({
        'name': '',
        'message': '',
        'photo': '',
        'status': true,
    });

    const handleSuccess = (filename) => {
        setData('photo',filename);
    };

     const handleError = (error) => {
        console.error("Upload error:", error);
    };

    useEffect(() => {
        if (initialData) {
          setData({
              name: initialData?.name || '',
              message: initialData?.message || '',
              photo: initialData?.photo || '',
              status: initialData?.status === 1,
          });
        }
    }, [initialData, setData]);

    const handleSave = (event) => {
        event.preventDefault();
        const formResponse = useFormResponse(() => {
            onClose?.(); 
        });
        put(`/admin/api/update_testimonial/${initialData.id}`, {
            preserveScroll: true,
                onSuccess: formResponse.onSuccess, 
                onError: formResponse.onError, 
            });
    };

    return(
        <>
        <Modal isOpen={isOpen} onClose={onClose} title="Edit Testimonial" size="large"
        primaryButtonText="Save Changes"
        onPrimaryAction={handleSave}
        processing={processing}
        >
            <form  onSubmit={handleSave}>
            <FormGroup label="Name" 
            value={data.name}
            onChange={(e) => setData('name', e.target.value)}
            invalidFeedback={errors.name}
            />
            
            <FormGroup
            id="message"
            label="Message"
            as="textarea"
            value={data.message}
            onChange={(e) => setData('message', e.target.value)}
            rows="4"
            invalidFeedback={errors.message}
            />

            <br />
            <FileUploadInput label="Upload Photo (400x400)px"
            buttonText={"Choose file (400x400)"}
            inputId="customFileUpload"
            uploadUrl="/admin/api/testimonial/upload_image"
            onSuccess={handleSuccess}
            onError={handleError} 
            previewUrl={`/storage/${data.photo}`}
            />

            <Switch
            id="customSwitch"
            label="Active"
            checked={data.status}
            onChange={({ target: { checked } }) =>
                setData(prevData => ({ ...prevData, status: checked }))
                }                  
                />
                <br/>
            </form>

        </Modal>
        </>
    );
}