import FormGroup from "@admin/ui/forms/FormGroup";
import Switch from "@admin/ui/forms/Switch";
import Modal from "@admin/ui/Modal";
import { useEffect, useState } from "react";
import { useFormResponse } from '@/hooks/useFormResponse';
import { useForm } from "@inertiajs/react";
export default function EditSlider( {isOpen, onClose, initialData }){
    const { data, setData, put, processing, errors, reset } = useForm({
        title: '',
        description:'',
        status: true,
    });
    
    useEffect(() => {
        if (initialData) {
          setData({
              title: initialData?.title || '',
              description: initialData?.description || '',
              status: initialData?.status === 1,
          });
        }
    }, [initialData, setData]);

    const handleSave = (event) => {
        event.preventDefault();
        const formResponse = useFormResponse(() => {
            onClose?.(); 
        });
        put(`/admin/api/update_slider/${initialData.id}`, {
            preserveScroll: true,
                onSuccess: formResponse.onSuccess, 
                onError: formResponse.onError, 
            });
    };

    return(
        <>
        <Modal isOpen={isOpen} onClose={onClose} title={`Edit ${initialData?.name}`} size="large"
        primaryButtonText="Save Changes"
        onPrimaryAction={handleSave}
        processing={processing}
        >

        <form onSubmit={handleSave}>
            <FormGroup label="Title" 
            value={data.title}
            onChange={(e) => setData('title', e.target.value)}
            invalidFeedback={errors.title}
            />

            <FormGroup
            id="description"
            label="Description"
            as="textarea"
            value={data.description}
            helpText="Write brief paragraph."
            onChange={(e) => setData("description", e.target.value)}
            rows="4"
            invalidFeedback={errors.description}
            />
            
            <Switch
            id="customSwitch"
            label="Active"
            checked={data.status}
            onChange={({ target: { checked } }) =>
                setData(prevData => ({ ...prevData, status: checked }))
                }                  
                />
                <br/>
            </form>

        </Modal>
        </>
    );
}