import Card from "@admin/ui/Card";
import Col from "@admin/ui/Col";
import FormGroup from "@admin/ui/forms/FormGroup";
import Switch from "@admin/ui/forms/Switch";
import TagMultiSelect from "@admin/ui/forms/TagMultiSelect";
import WysiwygEditor from "@admin/ui/forms/WysiwygEditor";
import FileUploadInput from "@admin/ui/forms/FileUploadInput";
import Row from "@admin/ui/Row";
import { useForm } from "@inertiajs/react";
import { useEffect, useState } from 'react';
import { Toaster } from "react-hot-toast";
import { useFormResponse } from '@/hooks/useFormResponse';

export default function Post(){
    const {data, setData,post, processing, errors,reset} = useForm({
        title: '',
        tags: '',
        categories: '',
        photo: '',
        description:'',
        status: true,
    });
    const [categoriesData, setCategories] = useState([]);
    useEffect(() => {
        // Fetch categories
        fetch('/api/post_categories')
            .then((response) => response.json())
            .then((data) => setCategories(data));
    }, []);

    const handleSuccess = (filename) => {
        setData('photo',filename);
    };

     const handleError = (error) => {
        console.error("Upload error:", error);
    };

    const handleSubmit =(event) =>{
        event.preventDefault();
        const formResponse = useFormResponse(reset);
        post('/admin/api/create_post',{
            ...formResponse,
            preserveScroll: true,
        });
    }

    return(
        <>
        <Toaster />
        <Row md="12" >
            <Col lg="12">
            <h2 className="page-title">Create New Post</h2>
            <p className="text-muted">Add posts to be displayed on the website</p>
            <Row>
            <Col lg="12">
            <Card md="6" title="New Post">
            <form onSubmit={handleSubmit}>
            <FormGroup label="Title" 
            value={data.title}
            onChange={(e) => setData('title', e.target.value)}
            invalidFeedback={errors.title}
            />

            <TagMultiSelect
                id="categories"
                label="Select Category"
                options={categoriesData.map((category) => ({
                    label: category.title,
                    value: category.id,
                }))}
                dataSelected={data.categories} 
                invalidFeedback={errors.categories}
                onChange={(selected) => setData((prev) => ({ ...prev, categories: selected }))}
                helpText="Choose one or more categories"
                />
            <FormGroup
            id="tags"
            label="tags"
            as="textarea"
            value={data.tags}
            helpText="Write tags separated by commas"
            onChange={(e) => setData('tags', e.target.value)}
            rows="4"
            invalidFeedback={errors.tags}
            />


            <br />
            <label className="label">Description (Required)</label>
            <WysiwygEditor
            value={data.description}
            onChange={description => setData('description', description)}
            height={400}
            placeholder="Write your description  here..."
            toolbar="full" />
            <br />
            <FileUploadInput label="Upload image (600x400)px" 
            buttonText={"Choose file (600x400)"}
            uploadUrl="/admin/api/post/upload_image"
            onSuccess={handleSuccess}
            onError={handleError}/>
            <Switch
            id="customSwitch"
            label="Active"
            checked={data.status}
            onChange={({ target: { checked } }) =>
                setData(prevData => ({ ...prevData, status: checked }))
                }                  
                />
                <br/>
            <button type="submit" className="btn btn-primary " disabled={processing}>Save</button>
            </form>
            </Card>
            </Col>
            </Row>
            </Col>
        </Row>
        </>
    );
}