import Card from "@admin/ui/Card";
import Col from "@admin/ui/Col";
import FormGroup from "@admin/ui/forms/FormGroup";
import Switch from "@admin/ui/forms/Switch";
import Row from "@admin/ui/Row";
import { useForm } from "@inertiajs/react";
import { useEffect, useState } from 'react';
import { useFormResponse } from '@/hooks/useFormResponse';
export default function Category(){
    const {data,post,setData,processing,errors,reset} = useForm({
        title: '',
        status: true,
    });

    const handleSubmit = (event) => {
        event.preventDefault();
        const formResponse = useFormResponse(reset);
        post('/admin/api/create_post_category', {
            ...formResponse,
            preserveScroll: true,  
        });
    };

    return(
        <>
        <Row md="12" >
            <Col lg="12">
            <h2 className="page-title">Create New Post Category</h2>
            <p className="text-muted">Manage Post categories</p>
            <Row>
            <Col lg="12">
            <Card md="6" title="Category Details">
            <form onSubmit={handleSubmit}>
            <FormGroup label="Title" 
            value={data.title}
            onChange={(e) => setData('title', e.target.value)}
            invalidFeedback={errors.title}
            />
            
            <Switch
            id="customSwitch"
            label="Active"
            checked={data.status}
            onChange={({ target: { checked } }) =>
                setData(prevData => ({ ...prevData, status: checked }))
                }                  
                />
                <br/>
            <button type="submit" className="btn btn-primary " disabled={processing}>Save</button>
            </form>
            </Card>
            </Col>
            </Row>
            </Col>
        </Row>
        </>
    );
}