import FormGroup from "@admin/ui/forms/FormGroup";
import Switch from "@admin/ui/forms/Switch";
import FileUploadInput from "@admin/ui/forms/FileUploadInput";
import Modal from "@admin/ui/Modal";
import { useEffect, useState } from "react";
import { useFormResponse } from '@/hooks/useFormResponse';
import { useForm } from "@inertiajs/react";

export default function EditBanner({ isOpen, onClose, initialData }){
    const {data, setData, put, processing, errors} = useForm({
        title: '',
        content: '',
        photo: '',
        status: true,
    });

    const handleSuccess = (filename) => {
        setData('photo', filename);
    };

    const handleError = (error) => {
        console.error("Upload error:", error);
    };

    useEffect(() => {
        if (initialData) {
          setData({
              title: initialData?.title || '',
              content: initialData?.content || '',
              photo: initialData?.photo || '',
              status: initialData?.status === 1,
          });
        }
    }, [initialData, setData]);

    const handleSave = (event) => {
        event.preventDefault();
        const formResponse = useFormResponse(() => {
            onClose?.(); 
        });
        put(`/admin/api/update_banner/${initialData.id}`, {
            preserveScroll: true,
            onSuccess: formResponse.onSuccess, 
            onError: formResponse.onError, 
        });
    };

    return(
        <>
        <Modal isOpen={isOpen} onClose={onClose} title={`Edit ${initialData?.title}`} size="large"
        primaryButtonText="Save Changes"
        onPrimaryAction={handleSave}
        processing={processing}>

        <form onSubmit={handleSave}>
            <FormGroup label="Title" 
            value={data.title}
            onChange={(e) => setData('title', e.target.value)}
            invalidFeedback={errors.title}
            />

            <div className="form-group">
                <label>Content</label>
                <textarea 
                    className="form-control"
                    rows="4"
                    value={data.content}
                    onChange={(e) => setData('content', e.target.value)}
                />
                {errors.content && <div className="invalid-feedback d-block">{errors.content}</div>}
            </div>

            <FileUploadInput label="Upload image (1900x1267)px" 
            buttonText={"Choose file (1900x1267)"}
            uploadUrl="/admin/api/banner/upload_image"
            onSuccess={handleSuccess}
            onError={handleError}
            previewUrl={`/storage/${data.photo}`}
            />
            
            <Switch
            id="customSwitch"
            label="Active"
            checked={data.status}
            onChange={({ target: { checked } }) =>
                setData(prevData => ({ ...prevData, status: checked }))
            }                  
            />
            <br/>
        </form>
        </Modal>
        </>
    );
}