import { Link, useForm } from "@inertiajs/react";

export default function Login(){
    const {data, setData, post, processing, errors, reset} = useForm({
        'email': '',
        'password': '',
    });

    function submit(e) {
        e.preventDefault();
        // Validate data before submission
        if (!data.email) {
            toast.error("Email is required, Please enter email");
            return;
        }
        if (!data.password) {
            toast.error("Password required, Please enter password");
            return;
        }
        post('/admin/login');
    }
    return(
        <>
        <div className="wrapper vh-100">
        <div className="row align-items-center h-100">
            <form className="col-lg-3 col-md-4 col-10 mx-auto text-center" onSubmit={submit}>
            <Link className="navbar-brand mx-auto mt-2 flex-fill text-center" href="#">
                <img src="/assets/user/images/matergo_website_logo.png" alt="Matergo Hotel" />
            </Link>
            <h1 className="h6 mb-3">Sign in</h1>
            {/* Display Danger Alert for Invalid Credentials */}
            {errors.message && (
                <div className="alert alert-danger">
                    {errors.message}
                </div>
            )}
            <div className="form-group">
                <label htmlFor="inputEmail" className="sr-only">Email address</label>
                <input type="email" id="inputEmail" className="form-control form-control-lg" placeholder="Email address" required="" autoFocus="" 
                value={data.email}
                onChange={e => setData('email', e.target.value)}/>
            </div>
            <div className="form-group">
                <label htmlFor="inputPassword" className="sr-only">Password</label>
                <input type="password" id="inputPassword" className="form-control form-control-lg" placeholder="Password" required="" 
                value={data.password}
                onChange={e => setData('password', e.target.value)}/>
                <div className="d-flex justify-content-end mt-2">
                    <Link href="/admin/forgot_password" className="text-primary text-decoration-none">
                    Forgot password?
                    </Link>
                </div>
            </div>
            <div className="checkbox mb-3">
                <label>
                <input type="checkbox" value="remember-me" /> Stay logged in </label>
            </div>
            <button className="btn btn-lg btn-primary btn-block" type="submit" disabled={processing}>Login</button>
            <p className="mt-5 mb-3 text-muted">© {new Date().getFullYear()}</p>
            </form>
        </div>
        </div>
        </>
    );
}