import React from 'react';

const Switch = ({
  id,
  checked = false,
  onChange,
  disabled = false,
  label = '',
  className = '',
  ...rest
}) => {
  const isChecked = checked === true || checked === "active" || checked === 1;
  return (
    <div className={`custom-control custom-switch ${className}`}>
      <input
        type="checkbox"
        className="custom-control-input"
        id={id}
        checked={isChecked}
        onChange={onChange}
        disabled={disabled}
        {...rest}
      />
      <label className="custom-control-label" htmlFor={id}>
        {label}
      </label>
    </div>
  );
};

export default Switch;
