import React from 'react';

const Modal = ({
  isOpen,
  onClose,
  title,
  primaryButtonText = "Save changes",
  onPrimaryAction,
  processing = false,
  children
}) => {
  if (!isOpen) return null;

  return (
    <div className="modal fade show"
      id="exampleModalCenter"
      style={{ 
        display: isOpen ? 'block' : 'none',
        position: 'fixed',
        top: 0,
        left: 0,
        width: '100%',
        height: '100%',
        overflow: 'auto',
        backgroundColor: 'rgba(0, 0, 0, 0.5)',
        zIndex: 1050
      }}>
      <div className="modal-dialog modal-dialog-centered modal-lg" 
        role="document" 
        style={{
          maxHeight: '90vh',
          margin: '1.75rem auto',
          position: 'relative',
          zIndex: 1051
        }}>
        <div className="modal-content" style={{ maxHeight: '85vh' }}>
          <div className="modal-header">
            <h5 className="modal-title">{title}</h5>
            <button
              type="button"
              className="close"
              onClick={onClose}
              aria-label="Close">
              <span>&times;</span>
            </button>
          </div>
          <div className="modal-body" style={{ overflowY: 'auto', maxHeight: 'calc(85vh - 170px)' }}>
            {children}
          </div>
          <div className="modal-footer">
            <button
              type="button"
              className="btn btn-secondary"
              onClick={onClose}>
              Close
            </button>
            <button
              type="button"
              className="btn btn-primary"
              onClick={onPrimaryAction}
              disabled={processing}
              >
              {primaryButtonText}
            </button>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Modal;