// Col.jsx
import React from 'react';

const Col = ({ children, size = "12", md, lg, xl }) => {
  // Build a classname string based on passed props
  const classes = [`col-${size}`];
  if (md) classes.push(`col-md-${md}`);
  if (lg) classes.push(`col-lg-${lg}`);
  if (xl) classes.push(`col-xl-${xl}`);
  return <div className={classes.join(" ")}>{children}</div>;
};

export default Col;
