import { Link, usePage } from "@inertiajs/react";

export default function Nav(){
    const { auth } = usePage().props;
    const avatarSrc = auth?.user?.photo ? `/storage/${auth.user.photo}` : '/assets/user/img/user.png';
    
    return(
        <nav className="topnav navbar navbar-light">
        <button type="button" className="navbar-toggler text-muted mt-2 p-0 mr-3 collapseSidebar">
          <i className="fe fe-menu navbar-toggler-icon"></i>
        </button>
        {/* <form className="form-inline mr-auto searchform text-muted">
          <input className="form-control mr-sm-2 bg-transparent border-0 pl-4 text-muted" type="search" placeholder="Type something..." aria-label="Search"/>
        </form> */}
        <ul className="nav">
          <li className="nav-item">
            <Link className="nav-link text-muted my-2" href="#" id="modeSwitcher" data-mode="dark" >
              <i className="fe fe-sun fe-16"></i>
            </Link>
          </li>
          {/* <li className="nav-item">
            <a className="nav-link text-muted my-2" href="./#" data-toggle="modal" data-target=".modal-shortcut">
              <span className="fe fe-grid fe-16"></span>
            </a>
          </li>
          <li className="nav-item nav-notif">
            <a className="nav-link text-muted my-2" href="./#" data-toggle="modal" data-target=".modal-notif">
              <span className="fe fe-bell fe-16"></span>
              <span className="dot dot-md bg-success"></span>
            </a>
          </li> */}
          {/* <li className="nav-item dropdown"> */}
          <li className="nav-item">
            <a className="nav-link dropdown-toggle text-muted pr-0 d-flex align-items-center" href="#" id="navbarDropdownMenuLink" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              {auth?.user?.photo ? (
                <img src={`/storage/${auth.user.photo}`} alt="..." className="avatar-img rounded-circle" style={{ width: '32px', height: '32px', objectFit: 'cover' }} />
              ) : (
                <span className="avatar-img rounded-circle d-flex align-items-center justify-content-center" style={{ width: '32px', height: '32px', background: '#e9ecef' }}>
                  <i className="fe fe-user" style={{ fontSize: '18px', color: '#6c757d' }}></i>
                </span>
              )}
            </a>
            <div className="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdownMenuLink">
              <Link className="dropdown-item" href="/admin/profile/edit">Profile</Link>
              {/* <a className="dropdown-item" href="#">Settings</a>
              <a className="dropdown-item" href="#">Activities</a> */}
            </div>
          </li>
        </ul>
      </nav>
    );
}