<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Database\Seeders\RoomSeeder;


class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        // Create hotel-specific permissions
        $permissions = [
            // Core hotel operations
            'manage accommodations',
            'manage event_rooms',
            'manage bookings',
            'manage testimonials',
            
            // Content management
            'manage menu_items',
            'manage faqs',
            'manage posts',
            'manage events',
            'manage gallery',
            'manage banners',
            'manage sliders',
            
            // Communication
            'manage contacts',
            
            // Admin only
            'manage company_info',
            'manage section_images',
            'manage users',
        ];

        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        // Create roles and assign permissions

        // 1. Admin - Full access to everything
        $adminRole = Role::create(['name' => 'admin']);
        $adminRole->givePermissionTo($permissions);

        // 2. Manager - Hotel operations (no user/company management)
        $managerRole = Role::create(['name' => 'manager']);
        $managerRole->givePermissionTo([
            'manage accommodations',
            'manage event_rooms',
            'manage bookings',
            'manage testimonials',
            'manage menu_items',
            'manage faqs',
            'manage posts',
            'manage events',
            'manage gallery',
            'manage banners',
            'manage sliders',
            'manage contacts',
        ]);

        // 3. Receptionist - Front desk operations
        $receptionistRole = Role::create(['name' => 'receptionist']);
        $receptionistRole->givePermissionTo([
            'manage bookings',
            'manage contacts',
            'manage testimonials',
        ]);

        // 4. Content Editor - Marketing and content management
        $contentEditorRole = Role::create(['name' => 'content_editor']);
        $contentEditorRole->givePermissionTo([
            'manage testimonials',
            'manage posts',
            'manage events',
            'manage gallery',
            'manage banners',
            'manage sliders',
            'manage faqs',
        ]);

        // Create default users
        $admin = User::create([
            'name' => 'Admin',
            'email' => 'admin@matergohotel.bi',
            'password' => Hash::make('password'),
        ]);
        $admin->assignRole($adminRole);

        $manager = User::create([
            'name' => 'Hotel Manager',
            'email' => 'manager@matergohotel.bi',
            'password' => Hash::make('password'),
        ]);
        $manager->assignRole($managerRole);

        $receptionist = User::create([
            'name' => 'Receptionist',
            'email' => 'reception@matergohotel.bi',
            'password' => Hash::make('password'),
        ]);
        $receptionist->assignRole($receptionistRole);

        // Seed room data
        $this->call(RoomSeeder::class);
    }
}
