<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pricing_rules', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('accommodation_id')->unique(); // One rule per accommodation category
            
            // Base prices (for 1 adult)
            $table->decimal('base_price_bif', 10, 2);
            $table->decimal('base_price_usd', 10, 2);
            $table->decimal('base_price_eur', 10, 2);
            
            // Additional adult pricing (per additional adult)
            $table->decimal('additional_adult_bif', 10, 2)->default(0);
            $table->decimal('additional_adult_usd', 10, 2)->default(0);
            $table->decimal('additional_adult_eur', 10, 2)->default(0);
            
            // Child surcharge (per child)
            $table->decimal('child_surcharge_bif', 10, 2)->default(0);
            $table->decimal('child_surcharge_usd', 10, 2)->default(0);
            $table->decimal('child_surcharge_eur', 10, 2)->default(0);
            
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('accommodation_id')
                ->references('id')
                ->on('accommodations')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pricing_rules');
    }
};
