<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rooms', function (Blueprint $table) {
            $table->id();
            $table->string('room_number'); // e.g., "101", "102", "201"
            $table->unsignedBigInteger('accommodation_id'); // Links to room category
            $table->boolean('is_available')->default(true); // Room availability status
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraint
            $table->foreign('accommodation_id')
                ->references('id')
                ->on('accommodations')
                ->onDelete('cascade');

            // Unique constraint: room_number should be unique per accommodation category
            $table->unique(['room_number', 'accommodation_id'], 'unique_room_per_category');
            
            // Index for faster queries
            $table->index('accommodation_id');
            $table->index('is_available');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rooms');
    }
};
