<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('company_information', function (Blueprint $table) {
            // Add separate WhatsApp fields for marketing and reception
            $table->string('whatsapp_marketing')->nullable()->after('whatsapp');
            $table->string('whatsapp_reception')->nullable()->after('whatsapp_marketing');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('company_information', function (Blueprint $table) {
            $table->dropColumn(['whatsapp_marketing', 'whatsapp_reception']);
        });
    }
};
