<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('accommodations', function (Blueprint $table) {
            // Add EUR price field after price_usd
            $table->decimal('price_eur', 10, 2)->nullable()->after('price_usd');
            // Add room identification fields after room_name
            $table->string('room_number')->nullable()->after('room_name');
            $table->string('room_category')->nullable()->after('room_number');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('accommodations', function (Blueprint $table) {
            $table->dropColumn(['price_eur', 'room_number', 'room_category']);
        });
    }
};
