<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Accommodation;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->string('bookable_type')->nullable()->after('id');
            $table->unsignedBigInteger('bookable_id')->nullable()->after('bookable_type');
            $table->dateTime('event_start')->nullable()->after('check_out');
            $table->dateTime('event_end')->nullable()->after('event_start');
            $table->index(['bookable_type', 'bookable_id']);
        });

        // Backfill existing bookings as accommodations
        if (Schema::hasColumn('bookings', 'accommodation_id')) {
            DB::table('bookings')
                ->whereNotNull('accommodation_id')
                ->update([
                    'bookable_type' => Accommodation::class,
                    'bookable_id' => DB::raw('accommodation_id'),
                ]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->dropIndex(['bookable_type', 'bookable_id']);
            $table->dropColumn(['bookable_type', 'bookable_id', 'event_start', 'event_end']);
        });
    }
};













