<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('event_rooms', function (Blueprint $table) {
            $table->id();

            // Basic information
            $table->string('name');
            $table->string('primary_photo')->nullable();

            // Pricing
            $table->decimal('price_fbu', 10, 2)->nullable();
            $table->decimal('price_usd', 10, 2)->nullable();

            // Description
            $table->text('short_description')->nullable();
            $table->longText('full_description')->nullable();

            // Capacity
            $table->integer('capacity')->nullable();

            // JSON fields
            $table->json('layouts')->nullable();      // ["U-shape", "Theatre", "Boardroom"]
            $table->json('equipment')->nullable();    // ["Projector", "Mic", "Speakers"]

            // Gallery
            $table->json('gallery')->nullable();

            // Status
            $table->boolean('status')->default(true);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('event_rooms');
    }
};
