<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('company_information', function (Blueprint $table) {
            $table->id();
            $table->longText('introduction')->nullable();
            $table->longText('vision')->nullable();
            $table->longText('mission')->nullable();
            $table->longText('objectives')->nullable();
            $table->string('address')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('whatsapp')->nullable(); 
            $table->string('youtube')->nullable(); 
            $table->string('tiktok')->nullable(); 
            $table->string('facebook')->default('https://facebook.com/')->nullable();
            $table->string('x')->default('https://twitter.com/')->nullable();
            $table->string('instagram')->default('https://instagram.com/')->nullable();
            $table->string('linkedin')->default('https://linkedin.com/')->nullable();
            $table->longText('story')->nullable();
            $table->longText('about')->nullable();
            $table->text('map_embed_code')->nullable();
            $table->timestamps();
        });

        DB::table('company_information')->insert([
            'introduction' => "Welcome to Matergo Hotel, an international-class hotel located in the heart of Gitega, Burundi. We offer high-quality services in accommodation, dining, conference facilities, and much more at competitive prices. Our mission is to combine modern comfort with authentic Burundian hospitality, providing a secure and pleasant environment for all our guests.",

            'vision' => 'To be the leading hospitality destination in Gitega, providing exceptional accommodation, dining, and event services that exceed guest expectations while maintaining authentic Burundian warmth and hospitality.',

            'mission' => 'Our mission is to deliver exceptional hospitality services by combining modern amenities with authentic Burundian hospitality. We are committed to providing comfortable accommodations, excellent dining experiences, and professional conference facilities that create memorable stays for our guests.',

            'objectives' => 'To provide world-class accommodation services with 5 distinct room types (Simple, Standard, Golden, Silver, VIP), offer exceptional dining experiences through our restaurant and bar, provide modern conference and event facilities, and maintain the highest standards of service excellence while promoting the beauty and culture of Gitega, Burundi.',

            'address' => 'HWGG+2F6 Gitega, Musinzira, Avenue du Stade, Gitega, Burundi',
            'phone' => '+257 22 40 51 77',
            'whatsapp' => '+257 62 654 197',
            'email' => 'info@matergohotel.bi',
            'facebook' => 'https://www.facebook.com/',
            'x' => 'https://x.com/',
            'instagram' => 'https://www.instagram.com/',
            'linkedin' => 'https://www.linkedin.com/company/',
            'story' => 'Matergo Hotel opened in June 2023 by the Bene Terezia Congregation to provide comfortable accommodations in the heart of Gitega. Our mission is to combine modern comfort with authentic Burundian hospitality, creating a welcoming environment for both local and international guests.',
            'about' => 'Matergo Hotel was inaugurated by His Excellency the President of the Republic of Burundi, General Major Evariste NDAYISHIMIYE, on June 10, 2023. It is an international-class hotel, offering high-quality services in accommodation, dining, conference facilities, and much more, at competitive prices. Located in Gitega, specifically in the Gitega-Musinzira commune on Avenue du Stade, the hotel is surrounded by the YOBA, RUTEGAMA, SHATANYA, and NYAMUGARI neighborhoods, providing a secure and pleasant environment.',
            'map_embed_code' => '<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d15163.318195994258!2d29.908866843851342!3d-3.4219144252734583!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x19c1450052f4f339%3A0xc5423fe3ccd305d8!2sMATERGO%20HOTEL!5e1!3m2!1sen!2sug!4v1765396988351!5m2!1sen!2sug" width="1536" height="560" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('company_information');
    }
};
