<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MenuItem extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name',
        'category',
        'price',
        'price_fbu',
        'price_usd',
        'price_eur',
        'description',
        'display_order',
        'status',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'price_fbu' => 'decimal:2',
        'price_usd' => 'decimal:2',
        'price_eur' => 'decimal:2',
        'status' => 'boolean',
        'display_order' => 'integer',
    ];
}
